/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;

public class TransporterStack {
    public ItemStack itemStack = ItemStack.field_190927_a;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public Direction idleDir = null;
    public BlockPos originalLocation;
    public BlockPos homeLocation;
    private BlockPos clientNext;
    private BlockPos clientPrev;
    private Path pathType;
    private List<BlockPos> pathToTarget = new ArrayList<BlockPos>();

    public static TransporterStack readFromNBT(CompoundNBT nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(nbtTags);
        return stack;
    }

    public static TransporterStack readFromUpdate(CompoundNBT nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.readFromUpdateTag(nbtTags);
        return stack;
    }

    public static TransporterStack readFromPacket(PacketBuffer dataStream) {
        TransporterStack stack = new TransporterStack();
        stack.read(dataStream);
        if (stack.progress == 0) {
            stack.progress = 5;
        }
        return stack;
    }

    public void write(LogisticalTransporterBase transporter, PacketBuffer buf) {
        buf.func_150787_b(TransporterUtils.getColorIndex(this.color));
        buf.func_150787_b(this.progress);
        buf.func_179255_a(this.originalLocation);
        buf.func_179249_a((Enum)this.pathType);
        if (this.pathToTarget.indexOf(transporter.getTilePos()) > 0) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.getNext(transporter));
        } else {
            buf.writeBoolean(false);
        }
        buf.func_179255_a(this.getPrev(transporter));
        buf.func_150788_a(this.itemStack);
    }

    public void read(PacketBuffer dataStream) {
        this.color = TransporterUtils.readColor(dataStream.func_150792_a());
        this.progress = dataStream.func_150792_a();
        this.originalLocation = dataStream.func_179259_c();
        this.pathType = (Path)dataStream.func_179257_a(Path.class);
        if (dataStream.readBoolean()) {
            this.clientNext = dataStream.func_179259_c();
        }
        this.clientPrev = dataStream.func_179259_c();
        this.itemStack = dataStream.func_150791_c();
    }

    public void writeToUpdateTag(LogisticalTransporterBase transporter, CompoundNBT updateTag) {
        updateTag.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        updateTag.func_74768_a("progress", this.progress);
        updateTag.func_218657_a("originalLocation", (INBT)NBTUtil.func_186859_a((BlockPos)this.originalLocation));
        updateTag.func_74768_a("pathType", this.pathType.ordinal());
        if (this.pathToTarget.indexOf(transporter.getTilePos()) > 0) {
            updateTag.func_218657_a("clientNext", (INBT)NBTUtil.func_186859_a((BlockPos)this.getNext(transporter)));
        }
        updateTag.func_218657_a("clientPrevious", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPrev(transporter)));
        this.itemStack.func_77955_b(updateTag);
    }

    public void readFromUpdateTag(CompoundNBT updateTag) {
        NBTUtils.setEnumIfPresent(updateTag, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.progress = updateTag.func_74762_e("progress");
        NBTUtils.setBlockPosIfPresent(updateTag, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(updateTag, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "clientNext", coord -> {
            this.clientNext = coord;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "clientPrevious", coord -> {
            this.clientPrev = coord;
        });
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)updateTag);
    }

    public void write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        nbtTags.func_74768_a("progress", this.progress);
        nbtTags.func_218657_a("originalLocation", (INBT)NBTUtil.func_186859_a((BlockPos)this.originalLocation));
        if (this.idleDir != null) {
            nbtTags.func_74768_a("idleDir", this.idleDir.ordinal());
        }
        if (this.homeLocation != null) {
            nbtTags.func_218657_a("homeLocation", (INBT)NBTUtil.func_186859_a((BlockPos)this.homeLocation));
        }
        nbtTags.func_74768_a("pathType", this.pathType.ordinal());
        this.itemStack.func_77955_b(nbtTags);
    }

    public void read(CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.progress = nbtTags.func_74762_e("progress");
        NBTUtils.setBlockPosIfPresent(nbtTags, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "idleDir", Direction::func_82600_a, dir -> {
            this.idleDir = dir;
        });
        NBTUtils.setBlockPosIfPresent(nbtTags, "homeLocation", coord -> {
            this.homeLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)nbtTags);
    }

    private void setPath(World world, List<BlockPos> path, Path type) {
        if (this.pathType != Path.NONE) {
            TransporterManager.remove(world, this);
        }
        this.pathToTarget = path;
        this.pathType = type;
        if (this.pathType != Path.NONE) {
            TransporterManager.add(world, this);
        }
    }

    public boolean hasPath() {
        return this.pathToTarget != null && this.pathToTarget.size() >= 2;
    }

    public List<BlockPos> getPath() {
        return this.pathToTarget;
    }

    public Path getPathType() {
        return this.pathType;
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(transporter, this, request, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getTileWorld(), newPath.getPath(), Path.DEST);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, TileEntityLogisticalSorter outputter, LogisticalTransporterBase transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(transporter, this, request, outputter, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getTileWorld(), newPath.getPath(), Path.DEST);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public boolean calculateIdle(LogisticalTransporterBase transporter) {
        Pair<List<BlockPos>, Path> newPath = TransporterPathfinder.getIdlePath(transporter, this);
        if (newPath == null) {
            return false;
        }
        if (newPath.getRight() == Path.HOME) {
            this.idleDir = null;
        }
        this.setPath(transporter.getTileWorld(), (List)newPath.getLeft(), (Path)((Object)newPath.getRight()));
        this.originalLocation = transporter.getTilePos();
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(LogisticalTransporterBase transporter) {
        return this.pathToTarget.indexOf(transporter.getTilePos()) == (this.pathType == Path.NONE ? 0 : 1);
    }

    public BlockPos getNext(LogisticalTransporterBase transporter) {
        if (!transporter.isRemote()) {
            int index = this.pathToTarget.indexOf(transporter.getTilePos()) - 1;
            if (index < 0) {
                return null;
            }
            return this.pathToTarget.get(index);
        }
        return this.clientNext;
    }

    public BlockPos getPrev(LogisticalTransporterBase transporter) {
        if (!transporter.isRemote()) {
            int index = this.pathToTarget.indexOf(transporter.getTilePos()) + 1;
            if (index < this.pathToTarget.size()) {
                return this.pathToTarget.get(index);
            }
            return this.originalLocation;
        }
        return this.clientPrev;
    }

    public Direction getSide(LogisticalTransporterBase transporter) {
        Direction side = null;
        if (this.progress < 50) {
            BlockPos prev = this.getPrev(transporter);
            if (prev != null) {
                side = WorldUtils.sideDifference(transporter.getTilePos(), prev);
            }
        } else {
            BlockPos next = this.getNext(transporter);
            if (next != null) {
                side = WorldUtils.sideDifference(next, transporter.getTilePos());
            }
        }
        return side == null ? Direction.DOWN : side;
    }

    @Contract(value="null, _, _ -> false")
    public boolean canInsertToTransporter(@Nullable LogisticalTransporterBase transmitter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        return transmitter != null && this.canInsertToTransporterNN(transmitter, from, transporterFrom);
    }

    public boolean canInsertToTransporterNN(@Nonnull LogisticalTransporterBase transporter, Direction from, @Nullable TileEntity tileFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.func_176734_d(), tileFrom);
    }

    public boolean canInsertToTransporterNN(@Nonnull LogisticalTransporterBase transporter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.func_176734_d(), transporterFrom);
    }

    public BlockPos getDest() {
        return this.pathToTarget.get(0);
    }

    @Nullable
    public Direction getSideOfDest() {
        if (this.hasPath()) {
            BlockPos lastTransporter = this.pathToTarget.get(1);
            return WorldUtils.sideDifference(lastTransporter, this.getDest());
        }
        return null;
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

        private static final Path[] PATHS;

        public static Path byIndexStatic(int index) {
            return MathUtils.getByIndexMod(PATHS, index);
        }

        static {
            PATHS = Path.values();
        }
    }
}

