/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class ModuleVeinMiningUnit
implements ICustomModule<ModuleVeinMiningUnit> {
    private IModuleConfigItem<Boolean> extendedMode;
    private IModuleConfigItem<ExcavationRange> excavationRange;

    @Override
    public void init(IModule<ModuleVeinMiningUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.extendedMode = configItemCreator.createDisableableConfigItem("extended_mode", MekanismLang.MODULE_EXTENDED_MODE, false, MekanismConfig.gear.mekaToolExtendedMining);
        this.excavationRange = configItemCreator.createConfigItem("excavation_range", MekanismLang.MODULE_EXCAVATION_RANGE, new ModuleEnumData<ExcavationRange>(ExcavationRange.class, module.getInstalledCount() + 1, ExcavationRange.LOW));
    }

    public boolean isExtended() {
        return this.extendedMode.get();
    }

    public int getExcavationRange() {
        return this.excavationRange.get().getRange();
    }

    public static Set<BlockPos> findPositions(BlockState state, BlockPos location, World world, int maxRange) {
        LinkedHashSet<BlockPos> found = new LinkedHashSet<BlockPos>();
        LinkedHashSet<BlockPos> openSet = new LinkedHashSet<BlockPos>();
        openSet.add(location);
        Block startBlock = state.func_177230_c();
        int maxCount = MekanismConfig.gear.disassemblerMiningCount.get() - 1;
        while (!openSet.isEmpty()) {
            BlockPos blockPos = (BlockPos)openSet.iterator().next();
            found.add(blockPos);
            openSet.remove(blockPos);
            if (found.size() > maxCount) {
                return found;
            }
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(-1, -1, -1), (BlockPos)blockPos.func_177982_a(1, 1, 1))) {
                Optional<BlockState> blockState;
                if (found.contains(pos) || maxRange != -1 && !(WorldUtils.distanceBetween(location, pos) <= (double)maxRange) || !(blockState = WorldUtils.getBlockState((IBlockReader)world, pos)).isPresent() || startBlock != blockState.get().func_177230_c() || !openSet.add(pos.func_185334_h())) continue;
                Mekanism.packetHandler.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(blockPos, pos), Vector3d.func_237489_a_((Vector3i)blockPos), Vector3d.func_237489_a_((Vector3i)pos), 10), world, blockPos);
            }
        }
        return found;
    }

    @Override
    public void addHUDStrings(IModule<ModuleVeinMiningUnit> module, PlayerEntity player, Consumer<ITextComponent> hudStringAdder) {
        if (module.isEnabled() && MekanismConfig.gear.mekaToolExtendedMining.getAsBoolean()) {
            hudStringAdder.accept((ITextComponent)MekanismLang.MODULE_EXTENDED_ENABLED.translateColored(EnumColor.DARK_GRAY, this.isExtended() ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED, this.isExtended() ? MekanismLang.MODULE_ENABLED_LOWER : MekanismLang.MODULE_DISABLED_LOWER));
        }
    }

    public static enum ExcavationRange implements IHasTextComponent
    {
        OFF(0),
        LOW(2),
        MED(4),
        HIGH(6),
        EXTREME(8);

        private final int range;
        private final ITextComponent label;

        private ExcavationRange(int range) {
            this.range = range;
            this.label = TextComponentUtil.getString(Integer.toString(range));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public int getRange() {
            return this.range;
        }
    }
}

