/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.chemical;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.holder.ConfigHolder;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.util.Direction;

public abstract class ConfigChemicalTankHolder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
extends ConfigHolder<TANK>
implements IChemicalTankHolder<CHEMICAL, STACK, TANK> {
    protected ConfigChemicalTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    void addTank(@Nonnull TANK tank) {
        this.slots.add(tank);
    }

    @Nonnull
    protected abstract List<TANK> getTanksFromSlot(ISlotInfo var1);

    @Override
    @Nonnull
    public List<TANK> getTanks(@Nullable Direction direction) {
        return this.getSlots(direction, this::getTanksFromSlot);
    }

    public static class ConfigSlurryTankHolder
    extends ConfigChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> {
        public ConfigSlurryTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.SLURRY;
        }

        @Override
        @Nonnull
        protected List<ISlurryTank> getTanksFromSlot(ISlotInfo slotInfo) {
            return slotInfo instanceof ChemicalSlotInfo.SlurrySlotInfo ? ((ChemicalSlotInfo.SlurrySlotInfo)slotInfo).getTanks() : Collections.emptyList();
        }
    }

    public static class ConfigPigmentTankHolder
    extends ConfigChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> {
        public ConfigPigmentTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.PIGMENT;
        }

        @Override
        @Nonnull
        protected List<IPigmentTank> getTanksFromSlot(ISlotInfo slotInfo) {
            return slotInfo instanceof ChemicalSlotInfo.PigmentSlotInfo ? ((ChemicalSlotInfo.PigmentSlotInfo)slotInfo).getTanks() : Collections.emptyList();
        }
    }

    public static class ConfigInfusionTankHolder
    extends ConfigChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> {
        public ConfigInfusionTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.INFUSION;
        }

        @Override
        @Nonnull
        protected List<IInfusionTank> getTanksFromSlot(ISlotInfo slotInfo) {
            return slotInfo instanceof ChemicalSlotInfo.InfusionSlotInfo ? ((ChemicalSlotInfo.InfusionSlotInfo)slotInfo).getTanks() : Collections.emptyList();
        }
    }

    public static class ConfigGasTankHolder
    extends ConfigChemicalTankHolder<Gas, GasStack, IGasTank> {
        public ConfigGasTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.GAS;
        }

        @Override
        @Nonnull
        protected List<IGasTank> getTanksFromSlot(ISlotInfo slotInfo) {
            return slotInfo instanceof ChemicalSlotInfo.GasSlotInfo ? ((ChemicalSlotInfo.GasSlotInfo)slotInfo).getTanks() : Collections.emptyList();
        }
    }
}

