/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.SpecialColors;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.commons.lang3.tuple.Pair;

public interface IFancyFontRenderer {
    public int getXSize();

    public FontRenderer getFont();

    default public int titleTextColor() {
        return SpecialColors.TEXT_TITLE.argb();
    }

    default public int headingTextColor() {
        return SpecialColors.TEXT_HEADING.argb();
    }

    default public int subheadingTextColor() {
        return SpecialColors.TEXT_SUBHEADING.argb();
    }

    default public int screenTextColor() {
        return SpecialColors.TEXT_SCREEN.argb();
    }

    default public int drawString(MatrixStack matrix, ITextComponent component, int x, int y, int color) {
        return this.getFont().func_243248_b(matrix, component, (float)x, (float)y, color);
    }

    default public int getStringWidth(ITextComponent component) {
        return this.getFont().func_238414_a_((ITextProperties)component);
    }

    default public void drawCenteredText(MatrixStack matrix, ITextComponent component, float x, float y, int color) {
        this.drawCenteredText(matrix, component, x, 0.0f, y, color);
    }

    default public void drawCenteredText(MatrixStack matrix, ITextComponent component, float xStart, float areaWidth, float y, int color) {
        int textWidth = this.getStringWidth(component);
        float centerX = xStart + areaWidth / 2.0f - (float)textWidth / 2.0f;
        this.drawTextExact(matrix, component, centerX, y, color);
    }

    default public void drawTitleText(MatrixStack matrix, ITextComponent text, float y) {
        this.drawCenteredTextScaledBound(matrix, text, this.getXSize() - 8, y, this.titleTextColor());
    }

    default public void drawScaledCenteredTextScaledBound(MatrixStack matrix, ITextComponent text, float left, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawScaledCenteredText(matrix, text, left, y, color, scale);
    }

    default public void drawScaledCenteredText(MatrixStack matrix, ITextComponent text, float left, float y, int color, float scale) {
        int textWidth = this.getStringWidth(text);
        float centerX = left - (float)textWidth / 2.0f * scale;
        this.drawTextWithScale(matrix, text, centerX, y, color, scale);
    }

    default public void drawCenteredTextScaledBound(MatrixStack matrix, ITextComponent text, float maxLength, float y, int color) {
        this.drawCenteredTextScaledBound(matrix, text, maxLength, 0.0f, y, color);
    }

    default public void drawCenteredTextScaledBound(MatrixStack matrix, ITextComponent text, float maxLength, float x, float y, int color) {
        float scale = Math.min(1.0f, maxLength / (float)this.getStringWidth(text));
        this.drawScaledCenteredText(matrix, text, x + (float)this.getXSize() / 2.0f, y, color, scale);
    }

    default public void drawTextExact(MatrixStack matrix, ITextComponent text, float x, float y, int color) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        this.drawString(matrix, text, 0, 0, color);
        matrix.func_227865_b_();
    }

    default public float getNeededScale(ITextComponent text, float maxLength) {
        int length = this.getStringWidth(text);
        return (float)length <= maxLength ? 1.0f : maxLength / (float)length;
    }

    default public void drawTextScaledBound(MatrixStack matrix, String text, float x, float y, int color, float maxLength) {
        this.drawTextScaledBound(matrix, (ITextComponent)TextComponentUtil.getString(text), x, y, color, maxLength);
    }

    default public void drawTextScaledBound(MatrixStack matrix, ITextComponent component, float x, float y, int color, float maxLength) {
        int length = this.getStringWidth(component);
        if ((float)length <= maxLength) {
            this.drawTextExact(matrix, component, x, y, color);
        } else {
            this.drawTextWithScale(matrix, component, x, y, color, maxLength / (float)length);
        }
        MekanismRenderer.resetColor();
    }

    default public void drawScaledTextScaledBound(MatrixStack matrix, ITextComponent text, float x, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawTextWithScale(matrix, text, x, y, color, scale);
    }

    default public void drawTextWithScale(MatrixStack matrix, ITextComponent text, float x, float y, int color, float scale) {
        this.prepTextScale(matrix, m -> this.drawString((MatrixStack)m, text, 0, 0, color), x, y, scale);
    }

    default public void prepTextScale(MatrixStack matrix, Consumer<MatrixStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)(y + yAdd), 0.0);
        matrix.func_227862_a_(scale, scale, scale);
        runnable.accept(matrix);
        matrix.func_227865_b_();
        MekanismRenderer.resetColor();
    }

    default public int drawWrappedTextWithScale(MatrixStack matrix, ITextComponent text, float x, float y, int color, float maxLength, float scale) {
        return new WrappedTextRenderer(this, text).renderWithScale(matrix, x, y, color, maxLength, scale);
    }

    default public void drawWrappedCenteredText(MatrixStack matrix, ITextComponent text, float x, float y, int color, float maxLength) {
        new WrappedTextRenderer(this, text).renderCentered(matrix, x, y, color, maxLength);
    }

    public static class WrappedTextRenderer {
        private final List<Pair<ITextComponent, Float>> linesToDraw = new ArrayList<Pair<ITextComponent, Float>>();
        private final IFancyFontRenderer font;
        private final String text;
        @Nullable
        private FontRenderer lastFont;
        private float lastMaxLength = -1.0f;
        private float lineLength = 0.0f;

        public WrappedTextRenderer(IFancyFontRenderer font, ITextComponent text) {
            this(font, text.getString());
        }

        public WrappedTextRenderer(IFancyFontRenderer font, String text) {
            this.font = font;
            this.text = text;
        }

        public void renderCentered(MatrixStack matrix, float x, float y, int color, float maxLength) {
            this.calculateLines(maxLength);
            float startY = y;
            for (Pair<ITextComponent, Float> p : this.linesToDraw) {
                this.font.drawTextExact(matrix, (ITextComponent)p.getLeft(), x - ((Float)p.getRight()).floatValue() / 2.0f, startY, color);
                startY += 9.0f;
            }
        }

        public int renderWithScale(MatrixStack matrix, float x, float y, int color, float maxLength, float scale) {
            this.calculateLines(maxLength / scale);
            this.font.prepTextScale(matrix, m -> {
                int startY = 0;
                for (Pair<ITextComponent, Float> p : this.linesToDraw) {
                    this.font.drawString((MatrixStack)m, (ITextComponent)p.getLeft(), 0, startY, color);
                    startY += 9;
                }
            }, x, y, scale);
            return this.linesToDraw.size();
        }

        void calculateLines(float maxLength) {
            FontRenderer font = this.font.getFont();
            if (font != null && (this.lastFont != font || this.lastMaxLength != maxLength)) {
                this.lastFont = font;
                this.lastMaxLength = maxLength;
                this.linesToDraw.clear();
                StringBuilder lineBuilder = new StringBuilder();
                StringBuilder wordBuilder = new StringBuilder();
                int spaceLength = this.lastFont.func_78256_a(" ");
                int wordLength = 0;
                for (char c : this.text.toCharArray()) {
                    if (c == ' ') {
                        lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                        wordBuilder = new StringBuilder();
                        wordLength = 0;
                        continue;
                    }
                    wordBuilder.append(c);
                    wordLength += this.lastFont.func_78256_a(Character.toString(c));
                }
                if (wordBuilder.length() > 0) {
                    lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                }
                if (lineBuilder.length() > 0) {
                    this.linesToDraw.add((Pair<ITextComponent, Float>)Pair.of((Object)TextComponentUtil.getString(lineBuilder.toString()), (Object)Float.valueOf(this.lineLength)));
                }
            }
        }

        StringBuilder addWord(StringBuilder lineBuilder, StringBuilder wordBuilder, float maxLength, int spaceLength, int wordLength) {
            float spacingLength;
            float f = spacingLength = lineBuilder.length() == 0 ? 0.0f : (float)spaceLength;
            if (this.lineLength + spacingLength + (float)wordLength > maxLength) {
                this.linesToDraw.add((Pair<ITextComponent, Float>)Pair.of((Object)TextComponentUtil.getString(lineBuilder.toString()), (Object)Float.valueOf(this.lineLength)));
                lineBuilder = new StringBuilder(wordBuilder);
                this.lineLength = wordLength;
            } else {
                if (spacingLength > 0.0f) {
                    lineBuilder.append(" ");
                }
                lineBuilder.append((CharSequence)wordBuilder);
                this.lineLength += spacingLength + (float)wordLength;
            }
            return lineBuilder;
        }

        public static int calculateHeightRequired(FontRenderer font, ITextComponent text, int width, float maxLength) {
            return WrappedTextRenderer.calculateHeightRequired(font, text.getString(), width, maxLength);
        }

        public static int calculateHeightRequired(final FontRenderer font, String text, final int width, float maxLength) {
            WrappedTextRenderer wrappedTextRenderer = new WrappedTextRenderer(new IFancyFontRenderer(){

                @Override
                public int getXSize() {
                    return width;
                }

                @Override
                public FontRenderer getFont() {
                    return font;
                }
            }, text);
            wrappedTextRenderer.calculateLines(maxLength);
            return 9 * wrappedTextRenderer.linesToDraw.size();
        }
    }
}

