/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;

public class MetallurgicInfuserRecipeCategory
extends BaseRecipeCategory<MetallurgicInfuserRecipe> {
    private final GuiSlot input;
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 17, 35);
    private final GuiSlot output;
    private final GuiBar<?> infusionBar;

    public MetallurgicInfuserRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.METALLURGIC_INFUSER, 5, 16, 166, 54);
        this.input = this.addSlot(SlotType.INPUT, 51, 43);
        this.output = this.addSlot(SlotType.OUTPUT, 109, 43);
        this.addSlot(SlotType.POWER, 143, 35).with(SlotOverlay.POWER);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, FULL_BAR, 164, 15));
        this.addSimpleProgress(ProgressType.RIGHT, 72, 47);
        this.infusionBar = this.addElement(new GuiEmptyBar(this, 7, 15, 4, 52));
    }

    public Class<? extends MetallurgicInfuserRecipe> getRecipeClass() {
        return MetallurgicInfuserRecipe.class;
    }

    public void setIngredients(MetallurgicInfuserRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInput().getRepresentations()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getOutputDefinition()));
        ingredients.setInputLists(MekanismJEI.TYPE_INFUSION, Collections.singletonList(((InfusionStackIngredient)recipe.getChemicalInput()).getRepresentations()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, MetallurgicInfuserRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 0, true, this.input, recipe.getItemInput().getRepresentations());
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 1, false, this.output, recipe.getOutputDefinition());
        ArrayList<ItemStack> infuseItemProviders = new ArrayList<ItemStack>();
        List<@NonNull TYPE> infusionStacks = ((InfusionStackIngredient)recipe.getChemicalInput()).getRepresentations();
        for (InfusionStack infusionStack : infusionStacks) {
            infuseItemProviders.addAll(MekanismJEI.INFUSION_STACK_HELPER.getStacksFor(infusionStack.getType(), true));
        }
        this.initItem((IGuiIngredientGroup<ItemStack>)itemStacks, 2, true, this.extra, infuseItemProviders);
        this.initChemical(recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_INFUSION), 0, true, this.infusionBar, infusionStacks);
    }
}

