/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.warning.WarningTracker;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.SelectedWindowData;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public interface IGuiWrapper {
    default public void displayTooltip(MatrixStack matrix, ITextComponent component, int x, int y, int maxWidth) {
        this.displayTooltips(matrix, Collections.singletonList(component), x, y, maxWidth);
    }

    default public void displayTooltip(MatrixStack matrix, ITextComponent component, int x, int y) {
        this.displayTooltips(matrix, Collections.singletonList(component), x, y);
    }

    default public void displayTooltips(MatrixStack matrix, List<ITextComponent> components, int xAxis, int yAxis) {
        this.displayTooltips(matrix, components, xAxis, yAxis, -1);
    }

    default public void displayTooltips(MatrixStack matrix, List<ITextComponent> components, int xAxis, int yAxis, int maxWidth) {
        net.minecraftforge.fml.client.gui.GuiUtils.drawHoveringText((MatrixStack)matrix, components, (int)xAxis, (int)yAxis, (int)this.getWidth(), (int)this.getHeight(), (int)maxWidth, (FontRenderer)this.getFont());
    }

    default public int getLeft() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiLeft();
        }
        return 0;
    }

    default public int getTop() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiTop();
        }
        return 0;
    }

    default public int getWidth() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getXSize();
        }
        return 0;
    }

    default public int getHeight() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getYSize();
        }
        return 0;
    }

    default public void addWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'addWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'removeWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public boolean currentlyQuickCrafting() {
        return false;
    }

    @Nullable
    default public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        Mekanism.logger.error("Tried to call 'getWindowHovering' but unsupported in {}", (Object)this.getClass().getName());
        return null;
    }

    @Nonnull
    default public BooleanSupplier trackWarning(@Nonnull WarningTracker.WarningType type, @Nonnull BooleanSupplier warningSupplier) {
        Mekanism.logger.error("Tried to call 'trackWarning' but unsupported in {}", (Object)this.getClass().getName());
        return warningSupplier;
    }

    @Nullable
    public FontRenderer getFont();

    default public void renderItem(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(matrix, stack, xAxis, yAxis, 1.0f);
    }

    default public void renderItem(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis, float scale) {
        GuiUtils.renderItem(matrix, this.getItemRenderer(), stack, xAxis, yAxis, scale, this.getFont(), null, false);
    }

    public ItemRenderer getItemRenderer();

    default public void renderItemTooltip(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis) {
        Mekanism.logger.error("Tried to call 'renderItemTooltip' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void renderItemTooltipWithExtra(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis, List<ITextComponent> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(matrix, stack, xAxis, yAxis);
        } else {
            Mekanism.logger.error("Tried to call 'renderItemTooltipWithExtra' but unsupported in {}", (Object)this.getClass().getName());
        }
    }

    default public void renderItemWithOverlay(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis, float scale, @Nullable String text) {
        GuiUtils.renderItem(matrix, this.getItemRenderer(), stack, xAxis, yAxis, scale, this.getFont(), text, true);
    }

    default public void setSelectedWindow(SelectedWindowData selectedWindow) {
        Mekanism.logger.error("Tried to call 'setSelectedWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void addFocusListener(GuiElement element) {
        Mekanism.logger.error("Tried to call 'addFocusListener' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeFocusListener(GuiElement element) {
        Mekanism.logger.error("Tried to call 'removeFocusListener' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void focusChange(GuiElement changed) {
        Mekanism.logger.error("Tried to call 'focusChange' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void incrementFocus(GuiElement current) {
        Mekanism.logger.error("Tried to call 'incrementFocus' but unsupported in {}", (Object)this.getClass().getName());
    }
}

