/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class SawmillCachedRecipe
extends CachedRecipe<SawmillRecipe> {
    private final IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private ItemStack recipeItem = ItemStack.field_190927_a;

    public SawmillCachedRecipe(SawmillRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler) {
        super(recipe);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeItem = this.inputHandler.getRecipeInput(((SawmillRecipe)this.recipe).getInput());
        if (this.recipeItem.func_190926_b()) {
            return -1;
        }
        if ((currentMax = this.inputHandler.operationsCanSupport(this.recipeItem, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((SawmillRecipe)this.recipe).getOutput(this.recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((SawmillRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(this.recipeItem, operations);
        this.outputHandler.handleOutput(((SawmillRecipe)this.recipe).getOutput(this.recipeItem), operations);
    }
}

