/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class PressurizedReactionCachedRecipe
extends CachedRecipe<PressurizedReactionRecipe> {
    private final IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private ItemStack recipeItem = ItemStack.field_190927_a;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private GasStack recipeGas = GasStack.EMPTY;

    public PressurizedReactionCachedRecipe(PressurizedReactionRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull GasStack> gasInputHandler, IOutputHandler<@NonNull Pair<@NonNull ItemStack, @NonNull GasStack>> outputHandler) {
        super(recipe);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeItem = this.itemInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputSolid());
        if (this.recipeItem.func_190926_b()) {
            return -1;
        }
        this.recipeFluid = this.fluidInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputFluid());
        if (this.recipeFluid.isEmpty()) {
            return -1;
        }
        this.recipeGas = this.gasInputHandler.getRecipeInput(((PressurizedReactionRecipe)this.recipe).getInputGas());
        if (this.recipeGas.isEmpty()) {
            return -1;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(this.recipeItem, currentMax);
        currentMax = this.fluidInputHandler.operationsCanSupport(this.recipeFluid, currentMax);
        if ((currentMax = this.gasInputHandler.operationsCanSupport(this.recipeGas, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((PressurizedReactionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeFluid, this.recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gas = this.gasInputHandler.getInput();
        if (gas.isEmpty()) {
            return false;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        if (fluid.isEmpty()) {
            return false;
        }
        return ((PressurizedReactionRecipe)this.recipe).test(this.itemInputHandler.getInput(), fluid, gas);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeItem.func_190926_b() || this.recipeFluid.isEmpty() || this.recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(this.recipeItem, operations);
        this.fluidInputHandler.use(this.recipeFluid, operations);
        this.gasInputHandler.use(this.recipeGas, operations);
        this.outputHandler.handleOutput(((PressurizedReactionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeFluid, this.recipeGas), operations);
    }
}

