/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class Chunk3D
extends ChunkPos {
    public final RegistryKey<World> dimension;

    public Chunk3D(int x, int z, RegistryKey<World> dimension) {
        super(x, z);
        this.dimension = dimension;
    }

    public Chunk3D(Coord4D coord) {
        this(coord.getX() >> 4, coord.getZ() >> 4, coord.dimension);
    }

    public Set<Chunk3D> expand(int chunkRadius) {
        if (chunkRadius < 0) {
            throw new IllegalArgumentException("Chunk radius cannot be negative.");
        }
        if (chunkRadius == 1) {
            return Collections.singleton(this);
        }
        HashSet<Chunk3D> ret = new HashSet<Chunk3D>();
        for (int i = this.field_77276_a - chunkRadius; i <= this.field_77276_a + chunkRadius; ++i) {
            for (int j = this.field_77275_b - chunkRadius; j <= this.field_77275_b + chunkRadius; ++j) {
                ret.add(new Chunk3D(i, j, this.dimension));
            }
        }
        return ret;
    }

    @Nonnull
    public String toString() {
        return "[Chunk3D: " + this.field_77276_a + ", " + this.field_77275_b + ", dim=" + this.dimension.func_240901_a_() + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Chunk3D && ((Chunk3D)((Object)obj)).field_77276_a == this.field_77276_a && ((Chunk3D)((Object)obj)).field_77275_b == this.field_77275_b && ((Chunk3D)((Object)obj)).dimension == this.dimension;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.field_77276_a;
        code = 31 * code + this.field_77275_b;
        code = 31 * code + this.dimension.hashCode();
        return code;
    }
}

