/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.MantleTileEntity;

public abstract class SingleItemHandler<T extends MantleTileEntity>
implements IItemHandlerModifiable {
    protected final T parent;
    private final int maxStackSize;
    private ItemStack stack = ItemStack.field_190927_a;

    public void setStack(ItemStack newStack) {
        this.stack = newStack;
        ((MantleTileEntity)((Object)this.parent)).markDirtyFast();
    }

    protected abstract boolean isItemValid(ItemStack var1);

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.isItemValid(stack);
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.stack;
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            this.setStack(stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot == 0) {
            int added;
            ItemStack current = this.getStack();
            if (current.func_190926_b()) {
                if (this.isItemValid(slot, stack)) {
                    int size = Math.min(stack.func_190916_E(), this.getSlotLimit(0));
                    if (!simulate) {
                        this.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - size));
                }
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)current, (ItemStack)stack) && (added = Math.min(stack.func_190916_E(), this.getSlotLimit(0) - current.func_190916_E())) > 0) {
                if (!simulate) {
                    current.func_190917_f(added);
                    this.setStack(current);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - added));
            }
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot != 0) {
            return ItemStack.field_190927_a;
        }
        if (this.stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount < this.stack.func_190916_E()) {
            ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)amount);
            if (!simulate) {
                this.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)(this.stack.func_190916_E() - amount)));
            }
            return result;
        }
        if (simulate) {
            return this.stack.func_77946_l();
        }
        ItemStack ret = this.stack;
        this.setStack(ItemStack.field_190927_a);
        return ret;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.stack.func_190926_b()) {
            this.stack.func_77955_b(nbt);
        }
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public SingleItemHandler(T parent, int maxStackSize) {
        this.parent = parent;
        this.maxStackSize = maxStackSize;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

