/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.screen.book.BookScreen;

@OnlyIn(value=Dist.CLIENT)
public class TextComponentDataRenderer {
    public static String drawText(MatrixStack matrixStack, int x, int y, int boxWidth, int boxHeight, TextComponentData[] data, int mouseX, int mouseY, FontRenderer fr, List<ITextComponent> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextComponentData item : data) {
            boolean mouseCheck;
            int box1W = 9999;
            fr.getClass();
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null) continue;
            if (item.text.getString().equals("\n")) {
                atX = x;
                fr.getClass();
                atY += 9;
                continue;
            }
            if (item.isParagraph) {
                atX = x;
                float f = atY;
                fr.getClass();
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            List<ITextProperties> textLines = TextComponentDataRenderer.splitTextComponentBySize(item.text, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                if (lineNumber == textLines.size() - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                ITextProperties textComponent = textLines.get(lineNumber);
                TextComponentDataRenderer.drawScaledTextComponent(matrixStack, fr, textComponent, atX, atY, item.dropShadow, item.scale);
                if (lineNumber < textLines.size() - 1) {
                    fr.getClass();
                    atY += 9;
                    atX = x;
                }
                if (lineNumber != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.func_243245_a(LanguageMap.func_74808_a().func_241870_a(textLines.get(textLines.size() - 1))) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                fr.getClass();
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            fr.getClass();
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseCheck = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltips != null && item.tooltips.length > 0) {
                if (BookScreen.debug) {
                    TextComponentDataRenderer.drawGradientRect(box1X, box1Y, box1W, box1H, -16711936, -16711936);
                    TextComponentDataRenderer.drawGradientRect(box2X, box2Y, box2W, box2H, -65536, -65536);
                    TextComponentDataRenderer.drawGradientRect(box3X, box3Y, box3W, box3H, -16776961, -16776961);
                    TextComponentDataRenderer.drawGradientRect(mouseX, mouseY, mouseX + 5, mouseY + 5, -65281, -256);
                }
                if (mouseCheck) {
                    tooltip.addAll(Arrays.asList(item.tooltips));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseCheck) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                if (item.dropShadow) {
                    fr.func_238405_a_(matrixStack, "...", (float)atX, (float)atY, 0);
                    break;
                }
                fr.func_238421_b_(matrixStack, "...", (float)atX, (float)atY, 0);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new StringTextComponent("Action: " + action).func_240699_a_(TextFormatting.GRAY));
        }
        return action;
    }

    public static List<ITextProperties> splitTextComponentBySize(ITextComponent textComponent, int width, int height, int firstWidth, FontRenderer fontRenderer, float scale) {
        ArrayList<Object> textLines;
        boolean needsWrap;
        block6: {
            block5: {
                int curWidth = (int)((float)fontRenderer.func_238414_a_((ITextProperties)textComponent) * scale);
                fontRenderer.getClass();
                int curHeight = (int)(9.0f * scale);
                needsWrap = false;
                textLines = new ArrayList<ITextProperties>();
                fontRenderer.getClass();
                if (curHeight == (int)(9.0f * scale) && curWidth > firstWidth) break block5;
                fontRenderer.getClass();
                if (curHeight == (int)(9.0f * scale) || curWidth <= width) break block6;
            }
            needsWrap = true;
        }
        if (needsWrap) {
            textLines = new ArrayList(fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)textComponent, firstWidth, Style.field_240709_b_));
        } else {
            textLines.add((ITextProperties)textComponent);
        }
        return textLines;
    }

    public static void drawScaledTextComponent(MatrixStack matrixStack, FontRenderer font, ITextProperties textComponent, float x, float y, boolean dropShadow, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        if (dropShadow) {
            font.func_238407_a_(matrixStack, LanguageMap.func_74808_a().func_241870_a(textComponent), 0.0f, 0.0f, 0);
        } else {
            font.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a(textComponent), 0.0f, 0.0f, 0);
        }
        RenderSystem.popMatrix();
    }

    private static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(f1, f2, f3, f).func_181675_d();
        vertexBuffer.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        vertexBuffer.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

