/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fml.ModList;

public class FallbackModelLoader
implements IModelLoader<BlockModelWrapper> {
    public static final FallbackModelLoader INSTANCE = new FallbackModelLoader();

    public void func_195410_a(IResourceManager resourceManager) {
    }

    public BlockModelWrapper read(JsonDeserializationContext context, JsonObject data) {
        JsonArray models = JSONUtils.func_151214_t((JsonObject)data, (String)"models");
        if (models.size() < 2) {
            throw new JsonSyntaxException("Fallback model must contain at least 2 models");
        }
        for (int i = 0; i < models.size(); ++i) {
            String debugName = "models[" + i + "]";
            JsonObject entry = JSONUtils.func_151210_l((JsonElement)models.get(i), (String)debugName);
            String modId = null;
            if (entry.has("fallback_mod_id")) {
                modId = JSONUtils.func_151200_h((JsonObject)entry, (String)"fallback_mod_id");
            } else if (entry.has("loader")) {
                ResourceLocation loader = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)entry, (String)"loader"));
                modId = loader.func_110624_b();
            }
            if (modId != null && !ModList.get().isLoaded(modId)) continue;
            try {
                return new BlockModelWrapper((BlockModel)context.deserialize((JsonElement)entry, BlockModel.class));
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException("Failed to parse fallback model " + debugName, (Throwable)e);
            }
        }
        throw new JsonSyntaxException("Failed to load fallback model, all " + models.size() + " variants had a failed condition");
    }

    static class BlockModelWrapper
    implements IModelGeometry<BlockModelWrapper> {
        private final BlockModel model;

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return this.model.func_228813_a_(bakery, this.model, spriteGetter, modelTransform, modelLocation, true);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.func_225614_a_(modelGetter, missingTextureErrors);
        }

        public BlockModelWrapper(BlockModel model) {
            this.model = model;
        }
    }
}

