/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools.render;

import com.ma.api.capabilities.Faction;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.gui.GuiTextures;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiRenderUtils {
    static final int POINT_RENDER_SIZE = 13;

    public static void bindManaweaveTextureRenderer() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.GUIDEBOOK_WIDGETS);
    }

    public static void renderManaweavePattern(MatrixStack matrixStack, int x, int y, float scale, IManaweavePattern p) {
        if (p == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        byte[][] pData = p.get();
        float pointSize = 13.0f;
        for (int k = 0; k < pData.length; ++k) {
            for (int j = 0; j < pData[k].length; ++j) {
                if (pData[k][j] == 0) continue;
                AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)(x - (int)Math.floor((float)j * pointSize)), (int)(y + (int)Math.floor((float)k * pointSize)), (int)0, (float)0.0f, (float)0.0f, (int)13, (int)13, (int)256, (int)256);
            }
        }
        RenderSystem.popMatrix();
    }

    public static void renderItemStackInGui(MatrixStack ms, ItemStack stack, int x, int y) {
        GuiRenderUtils.cpuMatrixToGLMatrix(ms, () -> Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y));
    }

    public static void renderStandardPlayerInventory(MatrixStack stack, int centerX, int centerY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.STANDALONE_INVENTORY_TEXTURE);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(centerX - 88), (int)(centerY - 45), (float)0.0f, (float)0.0f, (int)176, (int)90, (int)176, (int)90);
    }

    public static void cpuMatrixToGLMatrix(MatrixStack ms, Runnable toRun) {
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)ms.func_227866_c_().func_227870_a_());
        toRun.run();
        RenderSystem.popMatrix();
    }

    public static void drawGradientRect(MatrixStack ms, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        bufferbuilder.func_227888_a_(mat, (float)right, (float)top, 0.0f).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)left, (float)top, 0.0f).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)left, (float)bottom, 0.0f).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_227888_a_(mat, (float)right, (float)bottom, 0.0f).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void line2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, int color) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)1.0f);
        GL11.glColor3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void line2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, float weight, int color) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)weight);
        GL11.glColor3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void gradientline2d(float src_x, float src_y, float dst_x, float dst_y, float zLevel, int color1, int color2) {
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glLineWidth((float)4.0f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)((float)((color1 & 0xFF0000) >> 16) / 255.0f), (float)((float)((color1 & 0xFF00) >> 8) / 255.0f), (float)((float)(color1 & 0xFF) / 255.0f));
        GL11.glVertex3f((float)src_x, (float)src_y, (float)zLevel);
        GL11.glColor3f((float)((float)((color2 & 0xFF0000) >> 16) / 255.0f), (float)((float)((color2 & 0xFF00) >> 8) / 255.0f), (float)((float)(color2 & 0xFF) / 255.0f));
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
    }

    public static void fractalLine2d(int src_x, int src_y, int dst_x, int dst_y, float zLevel, int color, float displace) {
        GuiRenderUtils.fractalLine2d(src_x, src_y, dst_x, dst_y, zLevel, color, displace, 2.0f);
    }

    public static void fractalLine2d(int src_x, int src_y, int dst_x, int dst_y, float zLevel, int color, float displace, float fractalDetail) {
        Random rand = new Random();
        if (displace < fractalDetail) {
            GuiRenderUtils.line2d(src_x, src_y, dst_x, dst_y, zLevel, color);
        } else {
            int mid_x = (dst_x + src_x) / 2;
            int mid_y = (dst_y + src_y) / 2;
            mid_x = (int)((double)mid_x + ((double)rand.nextFloat() - 0.5) * (double)displace);
            mid_y = (int)((double)mid_y + ((double)rand.nextFloat() - 0.5) * (double)displace);
            GuiRenderUtils.fractalLine2d(src_x, src_y, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
            GuiRenderUtils.fractalLine2d(dst_x, dst_y, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
        }
    }

    public static void renderFactionIcon(MatrixStack matrixStack, Faction faction, int x, int y) {
        if (faction != Faction.NONE) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.OCCULUS_ICONS);
            switch (faction) {
                case ANCIENT_WIZARDS: {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)240.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case DEMONS: {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)248.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case FEY_COURT: {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)232.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
                case UNDEAD: {
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)224.0f, (float)248.0f, (int)8, (int)8, (int)256, (int)256);
                    break;
                }
            }
        }
    }
}

