/*
 * Decompiled with CFR 0.152.
 */
package com.ma.tools;

import com.ma.api.capabilities.Faction;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.ai.FollowOwnerGoal;
import com.ma.entities.ai.NeverTargetOwnerGoal;
import com.ma.entities.ai.SummonMeleeFallbackGoal;
import com.ma.entities.ai.TargetDefendOwnerGoal;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class SummonUtils {
    public static boolean isSummon(LivingEntity candidate) {
        return candidate.getPersistentData().func_74764_b("mana-and-artifice:summon_tag");
    }

    @Nullable
    public static PlayerEntity getSummoner(LivingEntity candidate) {
        if (!SummonUtils.isSummon(candidate)) {
            return null;
        }
        UUID summonerUUID = candidate.getPersistentData().func_186857_a("mana-and-artifice:summon_tag");
        return candidate.field_70170_p.func_217371_b(summonerUUID);
    }

    public static boolean setSummon(MobEntity candidate, PlayerEntity owner, int duration) {
        return SummonUtils.setSummon(candidate, owner, true, duration);
    }

    public static boolean setSummon(MobEntity candidate, PlayerEntity owner, boolean overrideAI, int duration) {
        if (SummonUtils.isSummon((LivingEntity)candidate)) {
            return false;
        }
        candidate.getPersistentData().func_186854_a("mana-and-artifice:summon_tag", owner.func_146103_bH().getId());
        candidate.getPersistentData().func_74757_a("ma:deathflag", true);
        candidate.func_195064_c(new EffectInstance((Effect)EffectInit.TIMED_DEATH.get(), duration));
        if (overrideAI) {
            candidate.field_70714_bg.func_75776_a(0, (Goal)new FollowOwnerGoal(candidate, 1.35, 8.0f, 20.0f, 32.0f, true));
            candidate.field_70715_bh.field_220892_d.clear();
            candidate.field_70715_bh.func_75776_a(0, (Goal)new NeverTargetOwnerGoal(candidate));
            candidate.field_70715_bh.func_75776_a(1, new TargetDefendOwnerGoal<LivingEntity>(candidate, LivingEntity.class, 10, true, false));
            if (!candidate.field_70714_bg.field_220892_d.stream().anyMatch(g -> g.func_220772_j() instanceof MeleeAttackGoal || g.func_220772_j() instanceof RangedAttackGoal || g.func_220772_j() instanceof RangedCrossbowAttackGoal)) {
                candidate.field_70714_bg.func_75776_a(1, (Goal)new SummonMeleeFallbackGoal(candidate, 1.35f, false));
            }
            candidate.field_70714_bg.field_220892_d.removeIf(g -> g.func_220772_j() instanceof AbstractRaiderEntity.FindTargetGoal);
        }
        return true;
    }

    public static List<MobEntity> getSummons(PlayerEntity summoner) {
        return SummonUtils.getSummons(summoner, summoner.field_70170_p);
    }

    public static List<MobEntity> getSummons(PlayerEntity summoner, World world) {
        LinkedList<MobEntity> summons = new LinkedList<MobEntity>();
        if (summoner != null && world != null && summoner.getPersistentData().func_74764_b("mana-and-artifice:summon_ids")) {
            int[] ids = summoner.getPersistentData().func_74759_k("mana-and-artifice:summon_ids");
            for (int i = 0; i < ids.length; ++i) {
                Entity e = world.func_73045_a(i);
                if (e == null || !(e instanceof MobEntity) || !SummonUtils.isSummon((LivingEntity)((MobEntity)e)) || SummonUtils.getSummoner((LivingEntity)((MobEntity)e)) != summoner) continue;
                summons.push((MobEntity)e);
            }
        }
        return summons;
    }

    public static void clampSummons(PlayerEntity player) {
        MutableInt max_summons = new MutableInt(2);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getAlliedFaction() == Faction.UNDEAD) {
                max_summons.add(p.getTier() - 2);
            }
        });
        LinkedList<Integer> summonIDs = new LinkedList<Integer>();
        if (player.getPersistentData().func_74764_b("mana-and-artifice:summon_ids")) {
            int[] ids = player.getPersistentData().func_74759_k("mana-and-artifice:summon_ids");
            for (int i = 0; i < ids.length; ++i) {
                summonIDs.add(ids[i]);
            }
            while (summonIDs.size() >= max_summons.getValue()) {
                Entity e = player.field_70170_p.func_73045_a(((Integer)summonIDs.pop()).intValue());
                if (e == null || !(e instanceof LivingEntity) || !SummonUtils.isSummon((LivingEntity)e) || SummonUtils.getSummoner((LivingEntity)e) != player) continue;
                e.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
            }
        }
    }

    public static void addTrackedSummon(PlayerEntity player, MobEntity summon) {
        LinkedList<Integer> summonIDs = new LinkedList<Integer>();
        if (player.getPersistentData().func_74764_b("mana-and-artifice:summon_ids")) {
            int[] ids = player.getPersistentData().func_74759_k("mana-and-artifice:summon_ids");
            for (int i = 0; i < ids.length; ++i) {
                summonIDs.add(ids[i]);
            }
        }
        summonIDs.add(summon.func_145782_y());
        player.getPersistentData().func_197646_b("mana-and-artifice:summon_ids", summonIDs);
    }
}

