/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.spells.shapes.ShapeRaytrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShapeTouch
extends ShapeRaytrace {
    public ShapeTouch(ResourceLocation registryName, ResourceLocation icon) {
        super(registryName, icon, new AttributeValuePair(Attribute.RANGE, 3.0f, 3.0f, 16.0f, 1.0f, 1.0f), new AttributeValuePair(Attribute.RADIUS, 0.0f, 0.0f, 3.0f, 1.0f));
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
        SpellTarget tgt;
        List<SpellTarget> targets = super.Target(source, world, modificationData, recipe);
        int radius = (int)Math.floor(modificationData.getValue(Attribute.RADIUS));
        if (radius > 0 && (tgt = targets.get(0)) != SpellTarget.NONE) {
            if (tgt.isBlock()) {
                targets = this.targetBlocksRadius(tgt, radius);
            } else if (tgt.isEntity()) {
                targets = this.targetBlocksEntity(source, tgt, radius, world);
            }
        }
        return targets;
    }

    private List<SpellTarget> targetBlocksRadius(SpellTarget origin, int radius) {
        Direction face = origin.getBlockFace(null);
        BlockPos targetPos = origin.getBlock();
        if (face == null) {
            return Arrays.asList(SpellTarget.NONE);
        }
        ArrayList<SpellTarget> targets = new ArrayList<SpellTarget>();
        if (face.func_176740_k() == Direction.Axis.X || face.func_176740_k() == Direction.Axis.Z) {
            for (int h = -radius; h <= radius; ++h) {
                for (int y = -1; y <= 2 * radius - 1; ++y) {
                    if (face.func_176740_k() == Direction.Axis.X) {
                        targets.add(new SpellTarget(targetPos.func_177982_a(0, y, h), face));
                        continue;
                    }
                    targets.add(new SpellTarget(targetPos.func_177982_a(h, y, 0), face));
                }
            }
        } else {
            for (int h = -radius; h <= radius; ++h) {
                for (int v = -radius; v <= radius; ++v) {
                    targets.add(new SpellTarget(targetPos.func_177982_a(h, 0, v), face));
                }
            }
        }
        return targets;
    }

    private List<SpellTarget> targetBlocksEntity(SpellSource source, SpellTarget center, int radius, World world) {
        return world.func_175674_a((Entity)source.getCaster(), center.getEntity().func_174813_aQ().func_186662_g((double)radius), entity -> entity.func_70067_L() && entity.func_70089_S() && entity != source.getCaster()).stream().map(e -> new SpellTarget((Entity)e)).collect(Collectors.toList());
    }
}

