/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.shapes;

import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.ItemInit;
import com.ma.items.sorcery.bound.ItemBoundBow;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapeBoundBow
extends Shape {
    public ShapeBoundBow(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair[0]);
    }

    @Override
    public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modifiedData, ISpellDefinition recipe) {
        if (source.getCaster() == null || !source.isPlayerCaster()) {
            return Arrays.asList(SpellTarget.NONE);
        }
        ItemStack held = source.getPlayer().func_184586_b(source.getHand());
        ItemStack replacement = ((ItemBoundBow)ItemInit.BOUND_BOW.get()).createFromSpell(held, recipe);
        int slot = source.getHand() == Hand.MAIN_HAND ? 98 : 99;
        source.getPlayer().func_174820_d(slot, replacement);
        return Arrays.asList(new SpellTarget((Entity)source.getCaster()));
    }

    @Override
    public float initialComplexity() {
        return 5.0f;
    }

    @Override
    public int requiredXPForRote() {
        return 100;
    }

    @Override
    public boolean spawnsTargetEntity() {
        return true;
    }

    @Override
    public boolean canBeOnRandomStaff() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

