/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.TeleportHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ComponentRecall
extends Component {
    public ComponentRecall(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 5.0f, 1.0f, 50.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        double maxDist;
        ItemStack markingRune;
        if (!source.hasCasterReference()) return ComponentApplicationResult.FAIL;
        if (!target.isEntity()) return ComponentApplicationResult.FAIL;
        if (!target.getEntity().func_70089_S()) return ComponentApplicationResult.FAIL;
        if (!target.getEntity().func_184222_aU()) return ComponentApplicationResult.FAIL;
        ItemStack itemStack = markingRune = source.getCaster().func_184614_ca().func_77973_b() == ItemInit.RUNE_MARKING.get() ? source.getCaster().func_184614_ca() : source.getCaster().func_184592_cb();
        if (markingRune.func_77973_b() != ItemInit.RUNE_MARKING.get()) {
            if (!source.isPlayerCaster()) return ComponentApplicationResult.FAIL;
            source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/recall.no_marker"), Util.field_240973_b_);
            return ComponentApplicationResult.FAIL;
        }
        BlockPos pos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(markingRune);
        if (pos == null) return ComponentApplicationResult.FAIL;
        double dist = target.getEntity().func_233580_cy_().func_177951_i((Vector3i)pos);
        if (dist > (maxDist = (double)(modificationData.getValue(Attribute.MAGNITUDE) * 500.0f)) * maxDist) {
            source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:components/recall.too_far"), Util.field_240973_b_);
            return ComponentApplicationResult.FAIL;
        }
        int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
        if (!this.casterTeamCheck(source, target)) return ComponentApplicationResult.FAIL;
        if (!this.magnitudeHealthCheck(source, target, magnitude, 20)) {
            return ComponentApplicationResult.FAIL;
        }
        TeleportHelper.teleportEntity(target.getEntity(), (RegistryKey<World>)context.getWorld().func_234923_W_(), new Vector3d((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5));
        return ComponentApplicationResult.SUCCESS;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ARCANE;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.ANCIENT_WIZARDS;
    }

    @Override
    public float initialComplexity() {
        return 50.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.FRIENDLY;
    }
}

