/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.effects.EffectInit;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.SummonUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;

public class ComponentPossession
extends Component {
    public ComponentPossession(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 30.0f, 30.0f, 120.0f, 30.0f, 10.0f), new AttributeValuePair(Attribute.MAGNITUDE, 1.0f, 1.0f, 3.0f, 1.0f, 10.0f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!context.getWorld().func_201670_d() && source.isPlayerCaster() && target.isLivingEntity() && target.getEntity() != source.getPlayer() && source.getPlayer().func_70660_b((Effect)EffectInit.MIND_VISION.get()) == null) {
            int magnitude = (int)modificationData.getValue(Attribute.MAGNITUDE);
            if (!SummonUtils.isSummon(target.getLivingEntity()) && !this.magnitudeHealthCheck(source, target, magnitude, 20)) {
                return ComponentApplicationResult.FAIL;
            }
            source.getPlayer().func_195064_c(new EffectInstance((Effect)EffectInit.POSSESSION.get(), (int)modificationData.getValue(Attribute.DURATION) * 20, 1));
            target.getLivingEntity().func_195064_c(new EffectInstance((Effect)EffectInit.POSSESSION.get(), (int)(modificationData.getValue(Attribute.DURATION) * 20.0f)));
            ServerMessageDispatcher.sendPlayerPosessionMessage((ServerPlayerEntity)source.getPlayer(), target.getEntity());
            source.getPlayer().getPersistentData().func_74768_a("posessed_entity_id", target.getLivingEntity().func_145782_y());
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.UNDEAD;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    public float initialComplexity() {
        return 50.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

