/*
 * Decompiled with CFR 0.152.
 */
package com.ma.spells.components;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.effects.EffectInit;
import com.ma.network.ServerMessageDispatcher;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;

public class ComponentMindVision
extends Component {
    public ComponentMindVision(ResourceLocation registryName, ResourceLocation guiIcon) {
        super(registryName, guiIcon, new AttributeValuePair(Attribute.DURATION, 30.0f, 5.0f, 120.0f, 15.0f, 2.5f));
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
        if (!context.getWorld().field_72995_K && source.isPlayerCaster() && target.isEntity() && target.getEntity() != source.getPlayer() && source.getPlayer().func_70660_b((Effect)EffectInit.MIND_VISION.get()) == null) {
            source.getPlayer().func_195064_c(new EffectInstance((Effect)EffectInit.MIND_VISION.get(), (int)modificationData.getValue(Attribute.DURATION) * 20));
            ServerMessageDispatcher.sendPlayerMindVisionMessage((ServerPlayerEntity)source.getPlayer(), target.getEntity());
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public Faction getFactionRequirement() {
        return Faction.UNDEAD;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public boolean canBeChanneled() {
        return false;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }
}

