/*
 * Decompiled with CFR 0.152.
 */
package com.ma.rituals.effects;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.rituals.IRitualContext;
import com.ma.api.sound.SFX;
import com.ma.items.ItemInit;
import com.ma.rituals.effects.RitualEffectCreateEssence;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;

public class RitualEffectSearingInferno
extends RitualEffectCreateEssence {
    public RitualEffectSearingInferno(ResourceLocation ritualName) {
        super(ritualName, new ItemStack((IItemProvider)ItemInit.MOTE_FIRE.get()));
    }

    @Override
    public ITextComponent canRitualStart(IRitualContext context) {
        Biome centerBiome = context.getWorld().func_226691_t_(context.getCenter());
        if (centerBiome.func_201856_r() != Biome.Category.NETHER) {
            return new TranslationTextComponent("ritual.mana-and-artifice.searing_inferno.not_nether");
        }
        return null;
    }

    @Override
    public SoundEvent getLoopSound(IRitualContext context) {
        return SFX.Loops.FIRE;
    }

    @Override
    public boolean spawnRitualParticles(IRitualContext context) {
        Vector3d center = new Vector3d((double)context.getCenter().func_177958_n() + 0.5, (double)context.getCenter().func_177956_o() + 0.1, (double)context.getCenter().func_177952_p() + 0.5);
        for (float i = 0.0f; i < 360.0f; i += 3.0f) {
            double y = Math.random() * 5.0;
            double radius = 1.0 + 2.0 * Math.pow(0.2, y);
            context.getWorld().func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get())), center.field_72450_a, center.field_72448_b + y, center.field_72449_c, 0.1 + Math.random() * 0.1, 0.0 + Math.random() * 0.1, radius);
        }
        return true;
    }
}

