/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.multiblock.block_matchers;

import com.ma.recipes.multiblock.block_matchers.IBlockMatcher;
import com.ma.tools.RLoc;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StairsBlockMatcher
implements IBlockMatcher {
    private final ResourceLocation id = RLoc.create("stairs");

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean match(World world, BlockPos offset, BlockPos worldPos, BlockState desired, BlockState inWorld, boolean matchBlock) {
        if (desired.func_177230_c() instanceof StairsBlock && inWorld.func_177230_c() instanceof StairsBlock) {
            if (matchBlock && desired.func_177230_c() != inWorld.func_177230_c()) {
                return false;
            }
            StairsShape desired_shape = (StairsShape)desired.func_177229_b((Property)StairsBlock.field_176310_M);
            if (desired_shape == StairsShape.STRAIGHT) {
                return this.MatchStateProperties(desired, inWorld, new String[0]);
            }
            if (this.MatchStateProperties(desired, inWorld, StairsBlock.field_176308_b.func_177701_a(), StairsBlock.field_204513_t.func_177701_a())) {
                int existingPalletteId;
                int[] PALETTE_SHAPE_MAP = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
                int desiredPalletteId = ((StairsShape)desired.func_177229_b((Property)StairsBlock.field_176310_M)).ordinal() * 4 + ((Direction)desired.func_177229_b((Property)StairsBlock.field_176309_a)).func_176736_b();
                return PALETTE_SHAPE_MAP[desiredPalletteId] == PALETTE_SHAPE_MAP[existingPalletteId = ((StairsShape)inWorld.func_177229_b((Property)StairsBlock.field_176310_M)).ordinal() * 4 + ((Direction)inWorld.func_177229_b((Property)StairsBlock.field_176309_a)).func_176736_b()];
            }
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getValidBlocks(Block block) {
        ArrayList<ItemStack> valid = new ArrayList<ItemStack>();
        if (block instanceof StairsBlock) {
            valid.add(new ItemStack((IItemProvider)block));
        }
        return valid;
    }
}

