/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.manaweaving;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IManaweavingRecipe;
import com.ma.recipes.ItemAndPatternCraftingInventory;
import com.ma.recipes.ItemAndPatternRecipe;
import com.ma.recipes.RecipeInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ManaweavingRecipe
extends ItemAndPatternRecipe
implements IManaweavingRecipe {
    private static final ResourceLocation NO_ENCHANT = new ResourceLocation("mana-and-artifice", "none");
    private static IForgeRegistry<Enchantment> __enchantRegistry;
    private ResourceLocation enchantment;
    private int enchantmentMagnitude;
    private boolean copyNBT = false;

    public ManaweavingRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        super.parseExtraJson(recipeJSON);
        if (recipeJSON.has("enchant")) {
            this.enchantment = new ResourceLocation(recipeJSON.get("enchant").getAsString());
            this.enchantmentMagnitude = recipeJSON.has("magnitude") ? recipeJSON.get("magnitude").getAsInt() : 1;
        }
        if (recipeJSON.has("copy_nbt")) {
            this.copyNBT = recipeJSON.get("copy_nbt").getAsBoolean();
        }
    }

    @Override
    public void runValidation() {
        super.runValidation();
        if (this.requiredItems.length > 9) {
            ManaAndArtifice.LOGGER.error("Manaweaving recipe can't have more than 9 items; this will be uncraftable! [" + this.func_199560_c().toString() + "]");
        }
        if (this.requiredPatterns.length > 6) {
            ManaAndArtifice.LOGGER.error("Manaweaving recipe can't have more than 6 patterns; this will be uncraftable! [" + this.func_199560_c().toString() + "]");
        }
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        if (!(inv instanceof ItemAndPatternCraftingInventory)) {
            return false;
        }
        ItemAndPatternCraftingInventory mwInv = (ItemAndPatternCraftingInventory)inv;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<String> patterns = new ArrayList<String>((Collection<String>)mwInv.getPatterns());
        for (int i = 0; i < 9; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            items.add(inv.func_70301_a(i));
        }
        return this.itemsMatchShapeless(items) && this.patternsMatchShaped(patterns);
    }

    public boolean matches(Map<Enchantment, Integer> runeEnchantment) {
        if (runeEnchantment.size() != 1 || this.enchantment == null) {
            return false;
        }
        for (Enchantment ench : runeEnchantment.keySet()) {
            if (!this.enchantment.equals((Object)ench.getRegistryName()) || this.enchantmentMagnitude != runeEnchantment.get(ench)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack func_77571_b() {
        IForgeRegistry itemRegistry;
        if ((this.__outputItem == null || this.__outputItem.func_190926_b()) && (itemRegistry = GameRegistry.findRegistry(Item.class)) != null) {
            Item outputItem = (Item)itemRegistry.getValue(this.output);
            if (outputItem == null) {
                return ItemStack.field_190927_a;
            }
            this.__outputItem = new ItemStack((IItemProvider)outputItem, this.outputQuantity);
            if (this.__outputNBT != null) {
                this.__outputItem.func_77982_d(this.__outputNBT.func_74737_b());
            }
            if (this.enchantment != null) {
                Enchantment resolved;
                if (__enchantRegistry == null) {
                    __enchantRegistry = GameRegistry.findRegistry(Enchantment.class);
                }
                if (__enchantRegistry != null && (resolved = (Enchantment)__enchantRegistry.getValue(this.enchantment)) != null) {
                    LinkedHashMap map = Maps.newLinkedHashMap();
                    map.put(resolved, this.enchantmentMagnitude);
                    EnchantmentHelper.func_82782_a((Map)map, (ItemStack)this.__outputItem);
                }
            }
        }
        return this.__outputItem;
    }

    @Override
    public boolean isEnchantment() {
        return !this.getEnchantment().equals((Object)NO_ENCHANT);
    }

    @Override
    public ResourceLocation getEnchantment() {
        return this.enchantment == null ? NO_ENCHANT : this.enchantment;
    }

    public void setEnchantment(ResourceLocation location) {
        this.enchantment = location;
    }

    @Override
    public int getEnchantmentMagnitude() {
        return this.enchantmentMagnitude;
    }

    public void setEnchantmentMagnitude(int magnitude) {
        this.enchantmentMagnitude = magnitude;
    }

    @Override
    public boolean getCopyNBT() {
        return this.copyNBT;
    }

    public void setCopyNBT(boolean copy) {
        this.copyNBT = copy;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.MANAWEAVING_RECIPE_SERIALIZER.get();
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return RecipeInit.MANAWEAVING_RECIPE_TYPE;
    }

    @Override
    protected int maxItems() {
        return 9;
    }

    @Override
    protected int maxPatterns() {
        return 6;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        Enchantment ench;
        ItemStack out = this.func_77571_b();
        if (this.isEnchantment() && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.getEnchantment())) != null) {
            out.func_200302_a(ench.func_200305_d(this.enchantmentMagnitude));
        }
        return out;
    }
}

