/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.manaweaving;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.ManaAndArtifice;
import com.ma.api.recipes.IManaweavePattern;
import com.ma.items.ItemInit;
import com.ma.recipes.AMRecipeBase;
import com.ma.recipes.RecipeInit;
import com.ma.tools.manaweave.RecognitionEngine;
import java.lang.reflect.MalformedParametersException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ManaweavingPattern
extends AMRecipeBase
implements IManaweavePattern {
    private byte[][] pattern;
    public static final int xBound = 11;
    public static final int yBound = 11;

    public ManaweavingPattern(ResourceLocation idIn) {
        super(idIn);
    }

    @Override
    public void parseExtraJson(JsonObject jsonobject) {
        JsonArray arr = jsonobject.getAsJsonArray("pattern");
        this.pattern = new byte[arr.size()][];
        for (int i = 0; i < arr.size(); ++i) {
            JsonElement elem = arr.get(i);
            if (!elem.isJsonArray()) continue;
            JsonArray subArr = elem.getAsJsonArray();
            this.pattern[i] = new byte[subArr.size()];
            for (int j = 0; j < subArr.size(); ++j) {
                this.pattern[i][j] = subArr.get(j).getAsByte();
            }
        }
        this.initializePattern();
    }

    private void initializePattern() {
        if (this.pattern.length == 0) {
            ManaAndArtifice.LOGGER.error("Manaweaving pattern {0} has a length of 0 - this won't work right!", (Object)this.func_199560_c());
            return;
        }
        if (this.pattern.length != 11) {
            throw new MalformedParametersException("Manaweave Pattern Array Bounds must be 11x11");
        }
        for (int i = 1; i < this.pattern.length; ++i) {
            if (this.pattern[i].length == 11) continue;
            throw new MalformedParametersException("Manaweave Pattern Array Bounds must be 11x11");
        }
        RecognitionEngine.instance.registerTrainingDataSample(this.func_199560_c(), this.pattern);
    }

    @Override
    public byte[][] get() {
        return this.pattern;
    }

    public void setPatternBytes(byte[][] value) {
        this.pattern = value;
        this.initializePattern();
    }

    private static final byte[][] blank() {
        byte[][] comp = new byte[11][];
        for (int i = 0; i < 11; ++i) {
            comp[i] = new byte[11];
        }
        return comp;
    }

    public static final ManaweavingPattern match(World world, int tier, Vector3f[] points, Vector3f[] directions) {
        int j;
        int i;
        Object newPoints;
        if (((Vector3f[])points).length == 1) {
            return null;
        }
        if (((Vector3f[])points).length == 2) {
            newPoints = new Vector3f[3];
            newPoints[0] = points[0];
            newPoints[2] = points[1];
            newPoints[1] = new Vector3f((points[0].func_195899_a() + points[1].func_195899_a()) / 2.0f, (points[0].func_195900_b() + points[1].func_195900_b()) / 2.0f, (points[0].func_195902_c() + points[1].func_195902_c()) / 2.0f);
            points = newPoints;
        }
        while (((Vector3f[])points).length < 100) {
            int next;
            newPoints = new ArrayList();
            for (i = 0; i < ((Vector3f[])points).length && (next = i + 1) != ((Vector3f[])points).length; ++i) {
                ((ArrayList)newPoints).add(points[i]);
                ((ArrayList)newPoints).add(new Vector3f((points[i].func_195899_a() + points[next].func_195899_a()) / 2.0f, (points[i].func_195900_b() + points[next].func_195900_b()) / 2.0f, (points[i].func_195902_c() + points[next].func_195902_c()) / 2.0f));
            }
            points = ((ArrayList)newPoints).toArray(new Vector3f[0]);
        }
        byte[][] transformedPattern = ManaweavingPattern.normalizePoints(world, points, directions);
        if (ManaAndArtifice.instance.isDebug) {
            ManaAndArtifice.LOGGER.debug("Pattern From Player Drawing:");
            for (i = 0; i < 11; ++i) {
                String str = "[ ";
                for (j = 0; j < 11; ++j) {
                    str = str + (transformedPattern[i][j] == 0 ? ". " : "O ");
                }
                str = str + "]";
                ManaAndArtifice.LOGGER.debug(str);
            }
        }
        boolean[][] bwPattern = new boolean[transformedPattern.length][transformedPattern[0].length];
        for (int i2 = 0; i2 < 11; ++i2) {
            for (j = 0; j < 11; ++j) {
                bwPattern[i2][j] = transformedPattern[i2][j] != 0;
            }
        }
        ResourceLocation matched = RecognitionEngine.instance.recognize(bwPattern);
        if (matched == null) {
            return null;
        }
        Optional recipe = world.func_199532_z().func_215367_a(matched);
        if (recipe != null && recipe.isPresent() && recipe.get() instanceof ManaweavingPattern) {
            return (ManaweavingPattern)recipe.get();
        }
        return null;
    }

    private static byte[][] normalizePoints(World world, Vector3f[] points, Vector3f[] directions) {
        Vector3f[] __points = new Vector3f[points.length];
        for (int i = 0; i < points.length; ++i) {
            __points[i] = points[i].func_229195_e_();
        }
        Vector3f min = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
        Vector3f max = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);
        ManaweavingPattern.projectPointsAlongZ(__points, directions, min, max);
        Vector3f delta = new Vector3f(max.func_195899_a(), max.func_195900_b(), max.func_195902_c());
        delta.func_195897_a(min);
        Vector3f centerPoint = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < __points.length; ++i) {
            centerPoint.func_195904_b(__points[i].func_195899_a(), __points[i].func_195900_b(), 0.0f);
            __points[i].setX((__points[i].func_195899_a() - min.func_195899_a()) / delta.func_195899_a());
            __points[i].setY((__points[i].func_195900_b() - min.func_195900_b()) / delta.func_195900_b());
        }
        centerPoint.func_195898_a(1.0f / (float)__points.length);
        byte[][] comp = ManaweavingPattern.blank();
        for (int i = 0; i < __points.length; ++i) {
            int x = (int)Math.floor(__points[i].func_195899_a() * 11.0f);
            int y = (int)Math.floor(__points[i].func_195900_b() * 11.0f);
            if (x >= 11 || x < 0 || y >= 11 || y < 0) continue;
            comp[x][y] = 1;
        }
        int M = comp.length;
        int N = comp[0].length;
        byte[][] ret = new byte[N][M];
        for (int r = 0; r < M; ++r) {
            for (int c = 0; c < N; ++c) {
                ret[r][c] = comp[r][M - 1 - c];
            }
        }
        return ret;
    }

    private static void projectPointsAlongZ(Vector3f[] points, Vector3f[] directions, Vector3f out_min, Vector3f out_max) {
        Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.length; ++i) {
            c.func_195904_b(points[i].func_195899_a(), points[i].func_195900_b(), points[i].func_195902_c());
        }
        c.func_195898_a(1.0f / (float)points.length);
        Vector3f d = directions[0];
        float yaw = d.func_195899_a();
        float pitch = d.func_195900_b();
        for (int i = 0; i < points.length; ++i) {
            points[i].func_195897_a(c);
            points[i].func_214905_a(Vector3f.field_229181_d_.func_229187_a_(yaw));
            points[i].func_214905_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
            points[i].func_229189_a_(c);
            points[i].setZ(c.func_195902_c());
            out_min.setX(Math.min(out_min.func_195899_a(), points[i].func_195899_a()));
            out_min.setY(Math.min(out_min.func_195900_b(), points[i].func_195900_b()));
            out_min.setZ(Math.min(out_min.func_195902_c(), points[i].func_195902_c()));
            out_max.setX(Math.max(out_max.func_195899_a(), points[i].func_195899_a()));
            out_max.setY(Math.max(out_max.func_195900_b(), points[i].func_195900_b()));
            out_max.setZ(Math.max(out_max.func_195902_c(), points[i].func_195902_c()));
        }
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return inv.func_174922_i() == 1 && inv.func_174923_h() == 1 && inv.func_70301_a(0).func_77973_b() == ItemInit.MANAWEAVER_DUMMY_ITEM.get();
    }

    public ItemStack assemble(CraftingInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.MANAWEAVING_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeInit.MANAWEAVING_PATTERN_TYPE;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        ItemStack stack = new ItemStack((IItemProvider)ItemInit.MANAWEAVER_WAND.get());
        stack.func_200302_a((ITextComponent)new TranslationTextComponent(this.func_199560_c().toString()));
        return stack;
    }

    @Override
    public ManaweavingPattern copy() {
        ManaweavingPattern clone = new ManaweavingPattern(this.func_199560_c());
        clone.setPatternBytes(this.pattern);
        return clone;
    }
}

