/*
 * Decompiled with CFR 0.152.
 */
package com.ma.recipes.eldrin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ma.api.affinity.Affinity;
import com.ma.recipes.ItemAndPatternCraftingInventory;
import com.ma.recipes.ItemAndPatternRecipe;
import com.ma.recipes.RecipeInit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EldrinAltarRecipe
extends ItemAndPatternRecipe {
    private HashMap<Affinity, Float> powerRequirements;
    private int[] colors = new int[]{0, 0};
    public static final int MAX_ITEMS = 9;

    public EldrinAltarRecipe(ResourceLocation idIn) {
        super(idIn);
        this.powerRequirements = new HashMap();
    }

    @Override
    public void parseExtraJson(JsonObject recipeJSON) {
        JsonElement colorElem;
        super.parseExtraJson(recipeJSON);
        JsonElement power_reqs = recipeJSON.get("power_requirements");
        if (power_reqs != null && power_reqs.isJsonArray()) {
            JsonArray reqsArray = power_reqs.getAsJsonArray();
            reqsArray.forEach(e -> {
                if (!e.isJsonObject()) {
                    return;
                }
                JsonObject elem = (JsonObject)e;
                if (elem.has("affinity") && elem.has("amount")) {
                    String affinity = elem.get("affinity").getAsString();
                    float amount = elem.get("amount").getAsFloat();
                    Affinity parsedAffinity = Affinity.UNKNOWN;
                    try {
                        parsedAffinity = Affinity.valueOf(affinity);
                    }
                    catch (Exception ex) {
                        return;
                    }
                    this.powerRequirements.put(parsedAffinity, Float.valueOf(amount));
                }
            });
        }
        if (recipeJSON.has("colors") && (colorElem = recipeJSON.get("colors")).isJsonArray()) {
            JsonArray colors = colorElem.getAsJsonArray();
            for (int i = 0; i < this.colors.length; ++i) {
                if (colors.size() < i || !(colorElem = colors.get(i)).isJsonPrimitive()) continue;
                this.colors[i] = colorElem.getAsInt();
            }
        }
    }

    @Override
    protected int maxItems() {
        return 9;
    }

    @Override
    protected int maxPatterns() {
        return 0;
    }

    public int getColorOne() {
        return this.colors[0];
    }

    public int getColorTwo() {
        return this.colors[1];
    }

    public HashMap<Affinity, Float> getPowerRequirements() {
        return this.powerRequirements;
    }

    public void setPowerRequirements(HashMap<Affinity, Float> map) {
        this.powerRequirements = map;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeInit.ELDRIN_ALTAR_RECIPE_SERIALIZER.get();
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return RecipeInit.ELDRIN_ALTAR_TYPE;
    }

    @Override
    public ItemStack getGuiRepresentationStack() {
        return this.func_77571_b();
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        if (!(inv instanceof ItemAndPatternCraftingInventory)) {
            return false;
        }
        ItemAndPatternCraftingInventory mwInv = (ItemAndPatternCraftingInventory)inv;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<String> patterns = new ArrayList<String>((Collection<String>)mwInv.getPatterns());
        for (int i = 0; i < 9; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            items.add(inv.func_70301_a(i));
        }
        return this.itemsMatchShapeless(items) && this.patternsMatchShaped(patterns);
    }
}

