/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles.base;

import com.ma.api.particles.MAParticleType;
import com.ma.particles.FXMovementType;
import com.ma.tools.math.MathUtils;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MAParticleBase
extends SpriteTexturedParticle {
    protected FXMovementType movementType;
    private Vector3 start;
    private Vector3 end;
    private Vector3 control_a;
    private Vector3 control_b;
    private ItemStack stack = null;
    private float uo;
    private float vo;
    private boolean decay_velocity = false;
    private boolean orbit_clockwise = true;
    private double angle;
    protected float maxAlpha = 1.0f;
    protected float life_padding = 0.0f;
    protected ArrayList<Vector3> colorTransitions = new ArrayList();
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            MAParticleBase.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            MAParticleBase.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:particle_renderer";
        }
    };

    protected MAParticleBase(ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (!this.apply_aging()) {
            this.move();
        }
    }

    public void setMoveVelocity(double x, double y, double z, boolean decay) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
        this.decay_velocity = decay;
        this.movementType = FXMovementType.VELOCITY;
    }

    public void setMoveStationary() {
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.movementType = FXMovementType.STATIONARY;
    }

    public void setMoveLerp(Vector3 start, Vector3 end) {
        this.start = start;
        this.end = end;
        this.movementType = FXMovementType.LERP_POINT;
    }

    public void setMoveLerp(double x, double y, double z, double goal_x, double goal_y, double goal_z) {
        this.setMoveLerp(new Vector3(x, y, z), new Vector3(goal_x, goal_y, goal_z));
    }

    public void setMoveBezier(Vector3 start, Vector3 end, Vector3 controlA, Vector3 controlB) {
        this.start = start;
        this.end = end;
        this.control_a = controlA;
        this.control_b = controlB;
        this.movementType = FXMovementType.BEZIER_POINT;
    }

    public void setMoveBezier(Vector3 start, Vector3 end) {
        this.start = start;
        this.end = end;
        this.generateBezierControlPoints();
        this.movementType = FXMovementType.BEZIER_POINT;
    }

    public void setMoveBezier(double x, double y, double z, double goal_x, double goal_y, double goal_z) {
        this.setMoveBezier(new Vector3(x, y, z), new Vector3(goal_x, goal_y, goal_z));
    }

    public void setMoveRandomly(double x, double y, double z) {
        this.movementType = FXMovementType.VELOCITY;
        this.field_187129_i = -x + Math.random() * 2.0 * y;
        this.field_187130_j = -y + Math.random() * 2.0 * y;
        this.field_187131_k = -z + Math.random() * 2.0 * z;
    }

    public void setMoveOrbit(double cX, double cY, double cZ, double forwardSpeed, double upSpeed, double radius) {
        this.start = new Vector3(cX, cY, cZ);
        this.end = new Vector3(forwardSpeed, radius, upSpeed);
        this.field_187130_j = upSpeed;
        this.orbit_clockwise = this.field_187122_b.field_73012_v.nextInt(10) < 5;
        this.field_70547_e = 30;
        this.angle = Math.random() * 360.0;
        this.movementType = FXMovementType.ORBIT;
        this.moveOrbit();
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public void setMoveSphereOrbit(double cX, double cY, double cZ, double forwardSpeed, double tilt, double radius) {
        this.start = new Vector3(cX, cY, cZ);
        this.end = new Vector3(forwardSpeed, radius, tilt);
        this.field_70547_e = 30;
        this.orbit_clockwise = this.field_187122_b.field_73012_v.nextInt(10) < 5;
        this.angle = Math.random() * 360.0;
        this.movementType = FXMovementType.SPHERE_ORBIT;
        this.moveSphereOrbit();
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public void setRenderAsStackParticles(ItemStack stack) {
        this.stack = stack.func_77946_l();
        this.func_217567_a(Minecraft.func_71410_x().func_175599_af().func_184393_a(this.stack, (World)this.field_187122_b, (LivingEntity)null).func_177554_e());
        this.uo = this.field_187136_p.nextFloat() * 3.0f;
        this.vo = this.field_187136_p.nextFloat() * 3.0f;
        this.field_70544_f /= 2.0f;
    }

    protected float func_217563_c() {
        if (this.stack != null && !this.stack.func_190926_b()) {
            return this.field_217569_E.func_94214_a((double)((this.uo + 1.0f) / 4.0f * 16.0f));
        }
        return super.func_217563_c();
    }

    protected float func_217564_d() {
        if (this.stack != null && !this.stack.func_190926_b()) {
            return this.field_217569_E.func_94214_a((double)(this.uo / 4.0f * 16.0f));
        }
        return super.func_217564_d();
    }

    protected float func_217562_e() {
        if (this.stack != null && !this.stack.func_190926_b()) {
            return this.field_217569_E.func_94207_b((double)(this.vo / 4.0f * 16.0f));
        }
        return super.func_217562_e();
    }

    protected float func_217560_f() {
        if (this.stack != null && !this.stack.func_190926_b()) {
            return this.field_217569_E.func_94207_b((double)((this.vo + 1.0f) / 4.0f * 16.0f));
        }
        return super.func_217560_f();
    }

    private void generateBezierControlPoints() {
        Vector3 o1 = new Vector3(this.start.x, this.start.y, this.start.z);
        Vector3 midPoint = new Vector3((this.start.x + this.end.x) / 2.0f, (this.start.y + this.end.y) / 2.0f, (this.start.z + this.end.z) / 2.0f);
        midPoint = midPoint.sub(o1);
        midPoint = midPoint.rotateYaw(1.5707964f);
        this.control_a = new Vector3(this.start.x + (this.end.x - this.start.x) / 3.0f, this.start.y + (this.end.y - this.start.y) / 3.0f, this.start.z + (this.end.z - this.start.z) / 3.0f);
        this.control_b = new Vector3(this.start.x + (this.end.x - this.start.x) / 3.0f * 2.0f, this.start.y + (this.end.y - this.start.y) / 3.0f * 2.0f, this.start.z + (this.end.z - this.start.z) / 3.0f * 2.0f);
        this.control_a = this.control_a.add(midPoint);
        this.control_b = this.control_b.add(midPoint);
    }

    protected void move() {
        if (this.movementType != null) {
            switch (this.movementType) {
                case BEZIER_POINT: {
                    this.moveBezier();
                    break;
                }
                case LERP_POINT: {
                    this.moveLerp();
                    break;
                }
                case VELOCITY: {
                    this.moveVelocity();
                    break;
                }
                case ORBIT: {
                    this.moveOrbit();
                    break;
                }
                case SPHERE_ORBIT: {
                    this.moveSphereOrbit();
                    break;
                }
            }
        }
    }

    protected boolean apply_aging() {
        int n = this.field_70546_d++;
        if ((float)n >= (float)this.field_70547_e + this.life_padding) {
            this.func_187112_i();
        }
        float agePct = MathUtils.clamp01((float)this.field_70546_d / (float)this.field_70547_e);
        this.lerpAlpha(agePct);
        this.lerpColors(agePct);
        return this.field_187133_m;
    }

    private void lerpAlpha(float agePct) {
        float alpha_T = this.maxAlpha;
        if (agePct < 0.2f) {
            alpha_T = agePct / 0.2f * this.maxAlpha;
        } else if (agePct > 0.8f) {
            alpha_T = (1.0f - (agePct - 0.8f) / 0.2f) * this.maxAlpha;
        }
        this.func_82338_g(alpha_T);
    }

    private void lerpColors(float agePct) {
        if (this.colorTransitions == null || this.colorTransitions.size() < 2) {
            return;
        }
        int cSize = this.colorTransitions.size();
        int cIndex = (int)Math.floor((float)cSize * agePct) % cSize;
        int nIndex = cIndex + 1;
        if (nIndex > cSize - 1) {
            nIndex = cSize - 1;
        }
        int colorAge = this.field_70547_e / cSize;
        float color_T = (float)(this.field_70546_d % colorAge) / (float)colorAge;
        Vector3 clr = Vector3.lerp(this.colorTransitions.get(cIndex), this.colorTransitions.get(nIndex), color_T);
        this.func_70538_b(clr.x / 255.0f, clr.y / 255.0f, clr.z / 255.0f);
    }

    private void moveOrbit() {
        this.end.y += 0.01f;
        this.angle = this.orbit_clockwise ? (this.angle += (double)this.end.x) : (this.angle -= (double)this.end.x);
        double pX = (double)this.start.x + Math.cos(this.angle) * (double)this.end.y;
        double pZ = (double)this.start.z + Math.sin(this.angle) * (double)this.end.y;
        this.func_187110_a(0.0, this.field_187130_j, 0.0);
        this.func_187109_b(pX, this.field_187127_g, pZ);
    }

    private void moveSphereOrbit() {
        this.angle += (double)this.end.x;
        float pX = (float)Math.cos(this.angle);
        float pZ = (float)Math.sin(this.angle);
        Vector3f horizPos = new Vector3f(pX, 0.0f, pZ);
        Quaternion rotation = Vector3f.field_229179_b_.func_229187_a_(this.end.z + (float)this.field_70546_d);
        horizPos.func_214905_a(rotation);
        horizPos.func_195898_a(this.end.y);
        this.func_187109_b(this.start.x + horizPos.func_195899_a(), this.start.y + horizPos.func_195900_b(), this.start.z + horizPos.func_195902_c());
    }

    private void moveVelocity() {
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.decay_velocity) {
            if (this.field_187127_g == this.field_187124_d) {
                this.field_187129_i *= 1.1;
                this.field_187131_k *= 1.1;
            }
            this.field_187129_i *= (double)0.96f;
            this.field_187130_j *= (double)0.96f;
            this.field_187131_k *= (double)0.96f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
        if (this.field_70545_g > 0.0f) {
            this.field_187130_j -= (double)this.field_70545_g;
        }
    }

    private void moveLerp() {
        float agePct = (float)this.field_70546_d / (float)this.field_70547_e;
        Vector3 pos = Vector3.lerp(this.start, this.end, agePct);
        this.func_187109_b(pos.x, pos.y, pos.z);
    }

    private void moveBezier() {
        this.setPosition(Vector3.bezier(this.start, this.end, this.control_a, this.control_b, (float)this.field_70546_d / (float)this.field_70547_e));
    }

    private void setPosition(Vector3 position) {
        this.func_187109_b(position.x, position.y, position.z);
    }

    protected int func_189214_a(float partialTick) {
        return 0xF000F0;
    }

    public void setLifePadding(int padding) {
        this.life_padding = padding;
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return this.stack != null && !this.stack.func_190926_b() ? IParticleRenderType.field_217601_a : NORMAL_RENDER;
    }

    protected static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class FXParticleFactoryBase
    implements IParticleFactory<MAParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXParticleFactoryBase(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public abstract Particle createParticle(MAParticleType var1, ClientWorld var2, double var3, double var5, double var7, double var9, double var11, double var13);

        protected void configureParticle(MAParticleBase particle, MAParticleType typeIn) {
            if (typeIn.getColor() != null) {
                particle.colorTransitions.clear();
                particle.func_70538_b(typeIn.getColor().getRed(), typeIn.getColor().getGreen(), typeIn.getColor().getBlue());
            }
            if (typeIn.getScale() != null) {
                particle.field_70544_f = typeIn.getScale().value();
            }
            if (typeIn.getLife() != null) {
                particle.field_70547_e = typeIn.getLife().value();
            }
            if (typeIn.getLifePadding() != null) {
                particle.setLifePadding(typeIn.getLife().value());
            }
            if (typeIn.getGravity() != null) {
                particle.field_70545_g = typeIn.getGravity().value();
            }
            if (typeIn.getPhysics() != null) {
                particle.field_190017_n = typeIn.getPhysics().value();
            }
            if (typeIn.getMover() != null) {
                typeIn.getMover().configureParticle(particle);
            }
            if (typeIn.getStack() != null) {
                particle.setRenderAsStackParticles(typeIn.getStack().value());
            }
        }
    }
}

