/*
 * Decompiled with CFR 0.152.
 */
package com.ma.particles;

import com.ma.api.particles.MAParticleType;
import com.ma.tools.math.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FXHeart
extends SpriteTexturedParticle {
    private static final IParticleRenderType NORMAL_RENDER = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXHeart.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            FXHeart.endRenderCommon();
        }

        public String toString() {
            return "mana-and-artifice:air";
        }
    };

    public FXHeart(ClientWorld world, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187130_j *= (double)0.2f;
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        this.field_70544_f *= 0.35f;
        this.field_70547_e = 30;
        this.field_190017_n = false;
        this.field_217569_E = sprite.func_217590_a(new Random());
    }

    private void setMoveVelocity(double x, double y, double z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
    }

    public float func_217561_b(float partialTicks) {
        return this.field_70544_f * (1.0f + (float)this.field_70546_d / (float)this.field_70547_e * 3.0f);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F = (float)((double)this.field_190014_F + Math.random() * Math.PI / 180.0);
        if (!this.apply_aging()) {
            this.moveVelocity();
        }
    }

    private void moveVelocity() {
        this.field_187130_j -= 0.004;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    private boolean apply_aging() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        return this.field_187133_m;
    }

    public Vector3 getPosition() {
        return new Vector3(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    protected int func_189214_a(float partialTick) {
        return 0xA00000;
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return NORMAL_RENDER;
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)1, (int)768, (int)1);
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableLighting();
        textureManager.func_110577_a(AtlasTexture.field_215262_g);
        Texture tex = textureManager.func_229267_b_(AtlasTexture.field_215262_g);
        tex.setBlurMipmap(true, false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    private static void endRenderCommon() {
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXHeartFactory
    implements IParticleFactory<MAParticleType> {
        protected final IAnimatedSprite spriteSet;

        public FXHeartFactory(IAnimatedSprite p_i50846_1_) {
            this.spriteSet = p_i50846_1_;
        }

        public Particle createParticle(MAParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXHeart particle = new FXHeart(worldIn, x, y, z, this.spriteSet);
            particle.setMoveVelocity(xSpeed, ySpeed, zSpeed);
            return particle;
        }
    }
}

