/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;

public class SpellNameAndIconMessage
extends BaseMessage {
    private int iconIndex;
    private String name;
    private int itemIndex = -1;
    private Hand hand;

    public SpellNameAndIconMessage(String name, int iconIndex, Hand hand) {
        this.name = name;
        this.iconIndex = iconIndex;
        this.hand = hand;
        this.messageIsValid = true;
    }

    public SpellNameAndIconMessage() {
        this.messageIsValid = false;
    }

    public void setItemIndex(int index) {
        this.itemIndex = index;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public String getName() {
        return this.name;
    }

    public Hand getHand() {
        return this.hand;
    }

    public static SpellNameAndIconMessage decode(PacketBuffer buf) {
        SpellNameAndIconMessage msg = new SpellNameAndIconMessage();
        try {
            msg.iconIndex = buf.readInt();
            msg.name = buf.func_150789_c(Short.MAX_VALUE);
            msg.hand = Hand.values()[buf.readByte()];
            msg.itemIndex = buf.readBoolean() ? buf.readInt() : -1;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpellNameAndIconMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.iconIndex);
        buf.func_180714_a(msg.name);
        buf.writeByte(msg.hand.ordinal());
        if (msg.itemIndex > -1) {
            buf.writeBoolean(true);
            buf.writeInt(msg.itemIndex);
        } else {
            buf.writeBoolean(false);
        }
    }
}

