/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_server;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.network.messages.TileEntityMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class InscriptionTableSetShapeMessage
extends TileEntityMessage {
    private ResourceLocation shape;

    public InscriptionTableSetShapeMessage() {
        super(null);
        this.messageIsValid = false;
    }

    public InscriptionTableSetShapeMessage(BlockPos position, ResourceLocation shape) {
        super(position);
        this.shape = shape;
        this.messageIsValid = true;
    }

    public final ResourceLocation getShape() {
        return this.shape;
    }

    public static final InscriptionTableSetShapeMessage decode(PacketBuffer buf) {
        InscriptionTableSetShapeMessage msg = new InscriptionTableSetShapeMessage();
        try {
            msg.shape = buf.func_192575_l();
            msg.pos = buf.func_179259_c();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static final void encode(InscriptionTableSetShapeMessage msg, PacketBuffer buf) {
        buf.func_192572_a(msg.shape);
        buf.func_179255_a(msg.pos);
    }

    public static final InscriptionTableSetShapeMessage fromInscriptionTable(InscriptionTableTile te) {
        ResourceLocation rLoc = new ResourceLocation("");
        if (te.getCurrentShape() != null) {
            rLoc = te.getCurrentShape().getPart().getRegistryName();
        }
        return new InscriptionTableSetShapeMessage(te.func_174877_v(), rLoc);
    }
}

