/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.messages.to_client;

import com.ma.ManaAndArtifice;
import com.ma.network.messages.BaseMessage;
import com.ma.recipes.multiblock.MultiblockDefinition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class StructureSyncMessage
extends BaseMessage {
    private CompoundNBT _data;
    private ResourceLocation structureID;

    private StructureSyncMessage(CompoundNBT data, ResourceLocation structureID) {
        this._data = data;
        this.structureID = structureID;
        this.messageIsValid = true;
    }

    private StructureSyncMessage() {
        this.messageIsValid = false;
    }

    public CompoundNBT getData() {
        return this._data;
    }

    public ResourceLocation getStructureID() {
        return this.structureID;
    }

    public static StructureSyncMessage decode(PacketBuffer buf) {
        StructureSyncMessage msg = new StructureSyncMessage();
        try {
            msg._data = buf.func_150793_b();
            msg.structureID = buf.func_192575_l();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading StructureSyncMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(StructureSyncMessage msg, PacketBuffer buf) {
        buf.func_150786_a(msg.getData());
        buf.func_192572_a(msg.getStructureID());
    }

    public static StructureSyncMessage fromMultiblock(MultiblockDefinition multiblock, ServerWorld world) {
        return new StructureSyncMessage(multiblock.serializeCoreBlocks(world), multiblock.func_199560_c());
    }
}

