/*
 * Decompiled with CFR 0.152.
 */
package com.ma.network.handlers;

import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.particles.MAParticleType;
import com.ma.blocks.tileentities.InscriptionTableTile;
import com.ma.capabilities.entity.MAPFXProvider;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.rituals.EntityRitual;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.gui.containers.entity.ContainerWanderingWizard;
import com.ma.network.messages.BaseMessage;
import com.ma.network.messages.to_client.CantripCastingTimerMessage;
import com.ma.network.messages.to_client.EntityStateMessage;
import com.ma.network.messages.to_client.ExtendedSlotContentsMessage;
import com.ma.network.messages.to_client.MAPFXMessage;
import com.ma.network.messages.to_client.MagicSyncMessageToClient;
import com.ma.network.messages.to_client.MindVisionMessage;
import com.ma.network.messages.to_client.PosessionMessage;
import com.ma.network.messages.to_client.ProgressionSyncMessageToClient;
import com.ma.network.messages.to_client.RoteProgressSyncMessageToClient;
import com.ma.network.messages.to_client.SetLiftPositionMessage;
import com.ma.network.messages.to_client.SetRitualCollectedReagentsMessage;
import com.ma.network.messages.to_client.SpawnParticleEffectMessage;
import com.ma.network.messages.to_client.SpawnParticleMessage;
import com.ma.network.messages.to_client.StructureSyncMessage;
import com.ma.network.messages.to_client.WanderingWizardInventoryMessage;
import com.ma.network.messages.to_client.WellspringPowerNetworkSyncMessage;
import com.ma.network.messages.to_client.WellspringSyncMessage;
import com.ma.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import com.ma.recipes.multiblock.MultiblockDefinition;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffers;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientMessageHandler {
    private static <T extends BaseMessage> boolean validateBasics(T message, NetworkEvent.Context ctx) {
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " received on wrong side: " + sideReceived);
            return false;
        }
        if (!message.isMessageValid()) {
            ManaAndArtifice.LOGGER.error(message.getClass().getName() + " was invalid: " + message);
            return false;
        }
        return true;
    }

    public static void handleMagicSyncMessage(MagicSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processMagicSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleEntityStateMessage(EntityStateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processEntityStateMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleProgressionSyncMessage(ProgressionSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processProgressionSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleRoteSyncMessage(RoteProgressSyncMessageToClient message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("RoteProgressSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processRoteSyncMessage((ClientWorld)clientWorld.get(), message));
    }

    public static void handleInscriptionTableCraftingUpdate(InscriptionTableCraftingUpdateMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MagicSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        InscriptionTableTile.handleCraftingUpdate((World)clientWorld.get(), message);
    }

    public static void handleSpawnParticleMessage(SpawnParticleMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SpawnParticleMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            ParticleType resolvedType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(message.getType());
            if (resolvedType == null || !(resolvedType instanceof MAParticleType)) {
                return;
            }
            ((ClientWorld)clientWorld.get()).func_195594_a((IParticleData)new MAParticleType((MAParticleType)resolvedType), (double)message.getPosition().x, (double)message.getPosition().y, (double)message.getPosition().z, (double)message.getSpeed().x, (double)message.getSpeed().y, (double)message.getSpeed().z);
        });
    }

    public static void handleSpawnParticleEffectMessage(SpawnParticleEffectMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("SpawnParticleMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> message.handle((World)clientWorld.get()));
    }

    public static void handleSetLiftPositionMessage(SetLiftPositionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> {
            PlayerEntity clientPlayer = ManaAndArtifice.instance.proxy.getClientPlayer();
            LazyOptional magicCap = clientPlayer.getCapability(PlayerMagicProvider.MAGIC);
            if (!magicCap.isPresent()) {
                return;
            }
            IPlayerMagic magicProperties = (IPlayerMagic)magicCap.orElse(null);
            if (magicProperties == null) {
                return;
            }
            magicProperties.setLiftPosition(message.getPosition());
        });
    }

    public static void handleSetRitualReagentData(SetRitualCollectedReagentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ManaAndArtifice.instance.proxy.getClientWorld().func_73045_a(message.getEntityID());
            if (e != null && e instanceof EntityRitual) {
                ((EntityRitual)e).readCollectedReagents(message.getData().func_150295_c("data", 10));
            }
        });
    }

    public static void handleCantripCastingTimerMessage(CantripCastingTimerMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> HUDOverlayRenderer.instance.setCastingCantrip(message.getCantripId(), message.getTicks()));
    }

    public static void handleWanderingWizardInventoryMessage(WanderingWizardInventoryMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        ctx.enqueueWork(() -> ClientMessageHandler.processWanderingWizardInventoryMessage(Minecraft.func_71410_x(), message));
    }

    public static void handleWellspringSyncMessage(WellspringSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("ProgressionSyncMessageToClient context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ((ClientWorld)clientWorld.get()).getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().readFromNBT(message.getData())));
    }

    public static void handleMindVisionMessage(MindVisionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MindVisionMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            if (message.getEntityID() == -1) {
                ManaAndArtifice.instance.proxy.resetRenderViewEntity();
            } else {
                Entity e = ((ClientWorld)clientWorld.get()).func_73045_a(message.getEntityID());
                if (e != null) {
                    ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
                }
            }
        });
    }

    public static void handlePosessionMessage(PosessionMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("PosessionMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ((ClientWorld)clientWorld.get()).func_73045_a(message.getEntityID());
            if (e != null) {
                ManaAndArtifice.instance.proxy.setRenderViewEntity(e);
            }
        });
    }

    public static void handleMAPFXMessage(MAPFXMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MAPFXMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            Entity e = ((ClientWorld)clientWorld.get()).func_73045_a(message.getEntityID());
            if (e != null && e instanceof LivingEntity) {
                ((LivingEntity)e).getCapability(MAPFXProvider.MAPFX).ifPresent(p -> p.setFlags(message.getFlags()));
            }
        });
    }

    public static void handleStructureSyncMessage(StructureSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("MAPFXMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> ((ClientWorld)clientWorld.get()).func_199532_z().func_215367_a(message.getStructureID()).ifPresent(r -> {
            if (r instanceof MultiblockDefinition) {
                ((MultiblockDefinition)r).deserializeCoreBlocks(message.getData());
            }
        }));
    }

    public static void handleWellspringPowerNetworkSyncMessage(WellspringPowerNetworkSyncMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("handleWellspringPowerNetworkSyncMessage context could not provide a ClientWorld");
            return;
        }
        ctx.enqueueWork(() -> {
            if (!((ClientWorld)clientWorld.get()).func_234923_W_().func_240901_a_().equals((Object)message.getDimension().func_240901_a_())) {
                return;
            }
            if (!((ClientWorld)clientWorld.get()).func_234923_W_().getRegistryName().equals((Object)message.getDimension().getRegistryName())) {
                return;
            }
            ctx.enqueueWork(() -> ((ClientWorld)clientWorld.get()).getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().deserializeNetworkStrength(ManaAndArtifice.instance.proxy.getClientPlayer(), message.getData())));
        });
    }

    public static void handleExtendedSlotContentsMessage(ExtendedSlotContentsMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (!ClientMessageHandler.validateBasics(message, ctx)) {
            return;
        }
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ManaAndArtifice.LOGGER.error("handleExtendedSlotContentsMessage context could not provide a ClientWorld");
            return;
        }
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            if (player.field_71070_bA.field_75152_c == message.getScreenID()) {
                player.field_71070_bA.func_75141_a(message.getSlotIndex(), message.getStack());
            }
        });
    }

    private static void processMagicSyncMessage(ClientWorld worldClient, MagicSyncMessageToClient message) {
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            int i;
            m.setMagicLevel(message.getLevel());
            if (message.syncCastingResource()) {
                m.getCastingResource().readNBT(message.getCastingResourceData());
            }
            m.setMagicXP(message.getXP());
            for (i = 0; i < Math.min(message.getAffinities().length, Affinity.values().length); ++i) {
                m.setAffinityDepth(Affinity.values()[i], message.getAffinities()[i]);
            }
            if (message.syncGrimoire()) {
                m.getGrimoireInventory().func_174888_l();
                for (i = 0; i < message.getGrimoireInventory().size(); ++i) {
                    m.getGrimoireInventory().func_70299_a(i, (ItemStack)message.getGrimoireInventory().get(i));
                }
            }
            if (message.syncRote()) {
                m.getRoteInventory().func_174888_l();
                for (i = 0; i < message.getRoteInventory().size(); ++i) {
                    m.getRoteInventory().func_70299_a(i, (ItemStack)message.getRoteInventory().get(i));
                }
            }
            if (message.syncCantrips()) {
                m.getCantripData().readFromNBT(message.getCantripData());
            }
        });
    }

    private static void processProgressionSyncMessage(ClientWorld worldClient, ProgressionSyncMessageToClient message) {
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            p.setTier(message.getTier(), null);
            p.setFactionStanding(message.getFactionStanding());
            p.setAlliedFaction(message.getFaction(), player);
            p.setTierProgression(message.getCompletedProgressionSteps());
        });
    }

    private static void processEntityStateMessage(ClientWorld clientWorld, EntityStateMessage message) {
        Entity entity = clientWorld.func_73045_a(message.getEntityID());
        if (entity != null && entity instanceof IAnimPacketSync) {
            ((IAnimPacketSync)entity).handlePacketData(message.getData());
        }
    }

    private static void processRoteSyncMessage(ClientWorld worldClient, RoteProgressSyncMessageToClient message) {
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
            for (Map.Entry<ResourceLocation, Integer> e : message.getRoteProgress().entrySet()) {
                r.setRoteXP(e.getKey(), e.getValue());
            }
        });
    }

    private static void processWanderingWizardInventoryMessage(Minecraft minecraft, WanderingWizardInventoryMessage message) {
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (message.getContainerId() == container.field_75152_c && container instanceof ContainerWanderingWizard) {
            ((ContainerWanderingWizard)container).setClientSideOffers(new MerchantOffers(message.getOffers().func_222199_a()));
            ((ContainerWanderingWizard)container).setXp(message.getExp());
            ((ContainerWanderingWizard)container).setMerchantLevel(message.getLevel());
            ((ContainerWanderingWizard)container).setHaxXPBar(message.getHasXPBar());
            ((ContainerWanderingWizard)container).setCanRestock(message.getCanRestock());
            ((ContainerWanderingWizard)container).setFinalized(message.getIsFinal());
        }
    }
}

