/*
 * Decompiled with CFR 0.152.
 */
package com.ma.loot.modifiers;

import com.google.gson.JsonObject;
import com.ma.enchantments.EnchantmentInit;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class BeheadingModifier
extends LootModifier {
    private final float chancePerLevel;
    private final ResourceLocation headID;
    private final ResourceLocation mobID;

    public BeheadingModifier(ILootCondition[] conditions, float chancePerLevel, ResourceLocation mobID, ResourceLocation headID) {
        super(conditions);
        this.chancePerLevel = chancePerLevel;
        this.headID = headID;
        this.mobID = mobID;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity dead = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        Entity killer = (Entity)context.func_216031_c(LootParameters.field_216284_d);
        if (dead != null && killer != null && killer instanceof LivingEntity && dead.func_200600_R().getRegistryName().equals((Object)this.mobID)) {
            Item item;
            LivingEntity killerLiving = (LivingEntity)killer;
            int level = Math.max(EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.BEHEADING.get()), (ItemStack)killerLiving.func_184614_ca()), EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.BEHEADING.get()), (ItemStack)killerLiving.func_184592_cb()));
            if (level > 0 && Math.random() < (double)((float)level * this.chancePerLevel) && (item = (Item)ForgeRegistries.ITEMS.getValue(this.headID)) != null && generatedLoot.stream().noneMatch(i -> i.func_77973_b() == item)) {
                generatedLoot.add(new ItemStack((IItemProvider)item));
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BeheadingModifier> {
        public BeheadingModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            float chancePerLevel = JSONUtils.func_151217_k((JsonObject)object, (String)"chancePerLevel");
            ResourceLocation headID = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"headID"));
            ResourceLocation mobID = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"mobID"));
            return new BeheadingModifier(ailootcondition, chancePerLevel, mobID, headID);
        }

        public JsonObject write(BeheadingModifier instance) {
            JsonObject obj = new JsonObject();
            obj.addProperty("chancePerLevel", (Number)Float.valueOf(instance.chancePerLevel));
            obj.addProperty("headID", instance.headID.toString());
            obj.addProperty("mobID", instance.mobID.toString());
            return obj;
        }
    }
}

