/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery.bound;

import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.entities.EntityInit;
import com.ma.entities.rituals.EntityBoundArrowShot;
import com.ma.items.renderers.bound.BoundBowItemRenderer;
import com.ma.items.sorcery.bound.IBoundItem;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ItemBoundBow
extends BowItem
implements IBoundItem,
ISyncable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final String CONTROLLER_NAME = "boundBowController";
    private static final int DRAW = 0;
    private static final int FIRE_TO_IDLE = 1;

    public ItemBoundBow() {
        super(new Item.Properties().setISTER(() -> BoundBowItemRenderer::new));
        GeckoLibNetwork.registerSyncable((ForgeRegistryEntry)this);
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public float getPassiveManaDrain(Entity entity) {
        return 0.5f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.handleInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        SpellRecipe recipe = this.getRecipe(stack);
        recipe.addItemTooltip(stack, worldIn, tooltip, flagIn, (PlayerEntity)mc.field_71439_g);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack createFromSpell(ItemStack original, ISpellDefinition recipe) {
        return IBoundItem.super.createFromSpell((Item)this, original, recipe);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        ItemStack restored = this.restoreItem(item);
        player.func_174820_d(98, restored);
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public int manaPerShot(PlayerEntity player, ItemStack stack) {
        SpellRecipe recipe = this.getRecipe(stack);
        SpellCaster.applyAdjusters(stack, player, recipe, SpellCastStage.CALCULATING_MANA_COST);
        return (int)recipe.getManaCost();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        MutableObject returnValue = new MutableObject((Object)ActionResult.func_226251_d_((Object)itemstack));
        SpellRecipe recipe = SpellRecipe.fromNBT(itemstack.func_77978_p());
        if (!this.canCastSpell(recipe, (LivingEntity)playerIn, handIn)) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (playerIn.field_71075_bZ.field_75098_d || m.getCastingResource().getAmount() >= (float)this.manaPerShot(playerIn, itemstack)) {
                playerIn.func_184598_c(handIn);
                this.sendPacket(0, worldIn, playerIn, handIn);
                returnValue.setValue((Object)ActionResult.func_226249_b_((Object)itemstack));
            }
        });
        return (ActionResult)returnValue.getValue();
    }

    private void sendPacket(int packetID, World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            this.sendPacket(packetID, worldIn, playerIn, stack);
        }
    }

    private void sendPacket(int packetID, World worldIn, PlayerEntity playerIn, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)stack, (ServerWorld)((ServerWorld)worldIn));
            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerIn);
            GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)this, (int)id, (int)packetID);
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            this.sendPacket(1, worldIn, playerentity, stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if (i < 0) {
                return;
            }
            float f = ItemBoundBow.getArrowVelocity(i);
            if (!((double)f < 0.1)) {
                playerentity.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    int mana = this.manaPerShot(playerentity, stack);
                    if (m.getCastingResource().getAmount() >= (float)mana && !worldIn.field_72995_K) {
                        EntityBoundArrowShot shot = new EntityBoundArrowShot((EntityType<? extends AbstractArrowEntity>)((EntityType)EntityInit.BOUND_ARROW_SHOT.get()), worldIn);
                        shot.func_70107_b(playerentity.func_226277_ct_(), playerentity.func_226278_cu_() + (double)playerentity.func_70047_e(), playerentity.func_226281_cx_());
                        shot.func_212361_a((Entity)playerentity);
                        shot.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        shot.setSpell(this.getRecipe(stack));
                        worldIn.func_217376_c((Entity)shot);
                    }
                    m.getCastingResource().consume(mana);
                    worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                });
            }
        }
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        if (event.getController().getAnimationState() == AnimationState.Stopped) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bound_bow.fire", Boolean.valueOf(false)).addAnimation("animation.bound_bow.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, CONTROLLER_NAME, 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void onAnimationSync(int id, int state) {
        if (state == 0) {
            AnimationController controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)CONTROLLER_NAME);
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.bound_bow.draw", Boolean.valueOf(false)).addAnimation("animation.bound_bow.draw_idle", Boolean.valueOf(true)));
        } else if (state == 1) {
            AnimationController controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)CONTROLLER_NAME);
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.bound_bow.fire", Boolean.valueOf(false)).addAnimation("animation.bound_bow.idle", Boolean.valueOf(true)));
        }
    }
}

