/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery.bound;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedSpellEffect;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.mutable.MutableBoolean;
import software.bernie.geckolib3.core.IAnimatable;

public interface IBoundItem
extends IAnimatable {
    public static final UUID BASE_RANGE_UUID = UUID.fromString("84468043-330D-428A-A8A3-688DB03E029F");

    public float getPassiveManaDrain(Entity var1);

    default public ItemStack createFromSpell(Item outputItem, ItemStack originalItem, ISpellDefinition spell) {
        CompoundNBT nbt = new CompoundNBT();
        originalItem.func_77955_b(nbt);
        ItemStack bound = new ItemStack((IItemProvider)outputItem);
        bound.func_196082_o().func_218657_a("original_item", (INBT)nbt);
        bound.func_200302_a(originalItem.func_200301_q());
        spell.writeToNBT(bound.func_196082_o());
        return bound;
    }

    default public ItemStack restoreItem(ItemStack stack) {
        return ItemStack.func_199557_a((CompoundNBT)stack.func_190925_c("original_item"));
    }

    default public SpellRecipe getRecipe(ItemStack stack) {
        return SpellRecipe.fromNBT(stack.func_196082_o());
    }

    default public void handleInventoryTick(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getCastingResource().getAmount() < this.getPassiveManaDrain(entityIn)) {
                    int restoreSlot = itemSlot;
                    if (restoreSlot == 0 && ((ItemStack)player.field_71071_by.field_184439_c.get(0)).hashCode() == stack.hashCode()) {
                        restoreSlot = 99;
                    }
                    player.func_174820_d(restoreSlot, this.restoreItem(stack));
                } else {
                    m.getCastingResource().consume(this.getPassiveManaDrain(entityIn));
                }
            });
        }
    }

    default public boolean canCastSpell(ISpellDefinition recipe, LivingEntity attacker, Hand hand) {
        if (!(attacker instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity caster = (PlayerEntity)attacker;
        MutableBoolean canCast = new MutableBoolean(true);
        caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (!caster.func_184812_l_()) {
                if (recipe.getComplexity() > (float)p.getTierMaxComplexity() || !recipe.canFactionCraft((IPlayerProgression)p) || recipe.getShape().getPart().getTier(attacker.field_70170_p) > p.getTier()) {
                    canCast.setFalse();
                }
                recipe.iterateComponents(c -> {
                    if (((Component)c.getPart()).getTier(attacker.field_70170_p) > p.getTier()) {
                        canCast.setFalse();
                    }
                });
            }
        });
        return canCast.booleanValue();
    }

    default public boolean affectTarget(ISpellDefinition recipe, LivingEntity attacker, LivingEntity target, Hand hand) {
        MutableBoolean applied = new MutableBoolean(false);
        if (!attacker.field_70170_p.field_72995_K && recipe.isValid()) {
            if (!this.canCastSpell(recipe, attacker, hand)) {
                return false;
            }
            SpellContext context = new SpellContext((ServerWorld)attacker.field_70170_p, recipe);
            SpellSource source = new SpellSource(attacker, hand);
            recipe.iterateComponents(c -> {
                int delay = (int)c.getValue(Attribute.DELAY) * 20;
                if (delay > 0) {
                    DelayedEventQueue.pushEvent(attacker.field_70170_p, new TimedDelayedSpellEffect(((Component)c.getPart()).getRegistryName().toString(), delay, source, new SpellTarget((Entity)target), (IModifiedSpellPart<Component>)c, context));
                    applied.setTrue();
                } else if (((Component)c.getPart()).ApplyEffect(source, new SpellTarget((Entity)target), (IModifiedSpellPart<Component>)c, context) == ComponentApplicationResult.SUCCESS) {
                    applied.setTrue();
                }
            });
            if (applied.isTrue() && !attacker.field_70170_p.field_72995_K) {
                SpellCaster.spawnClientFX(attacker.field_70170_p, attacker.func_213303_ch(), source, recipe);
            }
        }
        return applied.booleanValue();
    }
}

