/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.sorcery;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.ITieredItem;
import com.ma.api.items.MAItemGroups;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.gui.containers.providers.NamedSpellBook;
import com.ma.inventory.InventorySpellBook;
import com.ma.items.IRadialMenuItem;
import com.ma.items.ItemInit;
import com.ma.items.renderers.books.SpellBookRenderer;
import com.ma.items.sorcery.ISpellBookInventory;
import com.ma.items.sorcery.ItemBookOfRote;
import com.ma.items.sorcery.ItemSpell;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.messages.to_server.SpellBookSlotChangeMessage;
import com.ma.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class ItemSpellBook
extends ItemSpell
implements IRadialMenuItem,
ITieredItem<ItemSpellBook>,
IDyeableArmorItem {
    public static final String KEY_ACTIVE_SLOT = "active_slot";
    protected static final String KEY_USE_DURATION = "cur_spell_use_duration";
    public static final int MAX_ACTIVE_SLOT = 8;
    protected int tier = -1;
    public final boolean renderBookModel;
    public static String NBT_ID = "mana-and-artifice:spell_book_data";

    public ItemSpellBook(boolean renderBookModel) {
        this(() -> SpellBookRenderer::new, renderBookModel);
    }

    public ItemSpellBook(Supplier<Callable<ItemStackTileEntityRenderer>> ister, boolean renderBookModel) {
        super(new Item.Properties().func_200916_a(MAItemGroups.items).func_200917_a(1).setISTER(ister).func_208103_a(Rarity.EPIC));
        this.renderBookModel = renderBookModel;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack book = player.func_184586_b(hand);
        player.func_184609_a(hand);
        if (!world.field_72995_K && hand == Hand.MAIN_HAND && !this.openGuiIfModifierPressed(book, player, world) && book.func_77973_b() instanceof ItemSpellBook) {
            return this.castCurrentSpell(book, player, world, hand);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Override
    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j().func_225608_bj_()) {
            return this.castCurrentSpell(stack, context.func_195999_j(), context.func_195991_k(), context.func_221531_n()).func_188397_a();
        }
        return ActionResultType.PASS;
    }

    private ActionResult<ItemStack> castCurrentSpell(ItemStack book, PlayerEntity player, World world, Hand hand) {
        ItemStack selectedStack;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResult.func_226251_d_((Object)book);
        }
        ISpellBookInventory bookInv = this.getInventory(book, (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
        ItemStack itemStack = selectedStack = book.func_77973_b() == ItemInit.GRIMOIRE.get() || book.func_77973_b() instanceof ItemBookOfRote ? bookInv.getActiveSpells()[ItemSpellBook.getActiveSpellSlot(book)] : bookInv.getActiveSpells()[ItemSpellBook.getActiveSpellSlot(book)];
        if (!selectedStack.func_190926_b()) {
            ActionResult<ItemStack> result = ItemSpell.castSpellOnUse(selectedStack, world, player, hand, s -> true);
            switch (result.func_188397_a()) {
                case CONSUME: {
                    return ActionResult.func_226249_b_((Object)book);
                }
                case FAIL: {
                    return ActionResult.func_226251_d_((Object)book);
                }
                case PASS: {
                    return ActionResult.func_226250_c_((Object)book);
                }
                case SUCCESS: {
                    return ActionResult.func_226248_a_((Object)book);
                }
            }
        }
        return ActionResult.func_226251_d_((Object)book);
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        InventorySpellBook bookInv = new InventorySpellBook(stack);
        ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(stack) * 5);
        return super.func_77626_a(selectedStack);
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity) {
            ItemStack selectedStack = this.getSelectedStack(stack, (PlayerEntity)player);
            super.onUsingTick(selectedStack, player, count);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b(NBT_ID)) {
            stack.func_77982_d(nbt);
        }
        return null;
    }

    public static int getActiveSpellSlot(ItemStack item) {
        if (item.func_77942_o()) {
            return item.func_77978_p().func_74762_e(KEY_ACTIVE_SLOT);
        }
        return 0;
    }

    @Nullable
    public ISpellBookInventory getInventory(ItemStack item, @Nullable IPlayerMagic magic) {
        return new InventorySpellBook(item);
    }

    public static void setSlot(PlayerEntity player, ItemStack stack, int slot, boolean packet) {
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74768_a(KEY_ACTIVE_SLOT, slot);
            CompoundNBT spellCompound = ((ItemSpellBook)stack.func_77973_b()).getSpellCompound(stack, player);
            tag.func_74768_a(KEY_USE_DURATION, SpellRecipe.fromNBT(spellCompound).getMaxChannelTime());
            if (packet) {
                ClientMessageDispatcher.sendSpellBookSlotChange(slot);
            } else {
                ISpellBookInventory inv = ((ItemSpellBook)stack.func_77973_b()).getInventory(stack, (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
                if (inv != null) {
                    ItemStack spell = inv.getActiveSpells()[slot % inv.getActiveSpells().length];
                    if (!spell.func_190926_b()) {
                        stack.func_200302_a(spell.func_200301_q());
                    } else {
                        stack.func_135074_t();
                    }
                }
            }
        }
    }

    public static void handleSlotChangeMessage(SpellBookSlotChangeMessage msg, ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            ItemSpellBook.setSlot((PlayerEntity)player, stack, msg.getSlot(), false);
        }
    }

    @Override
    public CompoundNBT getSpellCompound(ItemStack stack, @Nullable PlayerEntity player) {
        if (stack.func_77973_b() instanceof ItemSpellBook) {
            IItemHandler bookInv = (IItemHandler)this.getInventory(stack, null);
            ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(stack) * 5);
            return selectedStack.func_190925_c("spell");
        }
        return new CompoundNBT();
    }

    protected ItemStack getSelectedStack(ItemStack bookStack, @Nullable PlayerEntity player) {
        if (bookStack.func_77973_b() instanceof ItemSpellBook) {
            IItemHandler bookInv = (IItemHandler)this.getInventory(bookStack, null);
            ItemStack selectedStack = bookInv.getStackInSlot(ItemSpellBook.getActiveSpellSlot(bookStack) * 5);
            return selectedStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public INamedContainerProvider getProvider(ItemStack stack) {
        return new NamedSpellBook(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IRadialMenuItem.super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getCachedtier() {
        return this.tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this.tier = tier;
    }
}

