/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.items.ItemInit;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum MAArmorMaterial implements IArmorMaterial
{
    BROKEN("broken", 5, new int[]{0, 0, 0, 0}, 0, SoundEvents.field_187728_s, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.INFUSED_SILK.get()})),
    INFUSED_SILK("infused_silk", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.field_187728_s, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.INFUSED_SILK.get()})),
    BONE("bone", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187716_o, 2.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196183_dw})),
    DEMON("demon", 33, new int[]{3, 6, 8, 3}, 15, SoundEvents.field_232681_Q_, 3.0f, 0.1f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234759_km_})),
    FEY("fey", 33, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187728_s, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150391_bh})),
    COUNCIL("council", 33, new int[]{1, 4, 5, 2}, 12, SoundEvents.field_187716_o, 0.0f, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.RUNIC_SILK.get()}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyValue<Ingredient> repairMaterial;

    private MAArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = new LazyValue(repairMaterial);
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * this.maxDamageFactor;
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.damageReductionAmountArray[slotIn.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return "mana-and-artifice:" + this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

