/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.ManaAndArtifice;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface ISetItem {
    public static final EquipmentSlotType[] defaultSlotTypes = new EquipmentSlotType[]{EquipmentSlotType.CHEST, EquipmentSlotType.FEET, EquipmentSlotType.HEAD, EquipmentSlotType.LEGS};

    public ResourceLocation getSetIdentifier();

    default public int itemsForSetBonus() {
        return 4;
    }

    default public void applySetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
    }

    default public void removeSetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
    }

    default public EquipmentSlotType[] getValidSetSlots() {
        return defaultSlotTypes;
    }

    default public void addSetTooltip(List<ITextComponent> tooltip) {
        boolean setEquipped = this.isSetEquipped((LivingEntity)ManaAndArtifice.instance.proxy.getClientPlayer());
        String s = new TranslationTextComponent(this.getSetIdentifier().toString()).getString();
        for (String spl : s.split("\n")) {
            tooltip.add((ITextComponent)new StringTextComponent(spl).func_240699_a_(setEquipped ? TextFormatting.GREEN : TextFormatting.RED));
        }
    }

    default public boolean isSetEquipped(LivingEntity living) {
        if (living == null) {
            return false;
        }
        int count = 0;
        for (EquipmentSlotType slot : this.getValidSetSlots()) {
            ItemStack stack;
            if (slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND || !((stack = living.func_184582_a(slot)).func_77973_b() instanceof ISetItem) || !((ISetItem)stack.func_77973_b()).getSetIdentifier().equals((Object)this.getSetIdentifier())) continue;
            ++count;
        }
        return count >= this.itemsForSetBonus();
    }
}

