/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items.armor;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.IFactionSpecific;
import com.ma.api.items.ITieredItem;
import com.ma.api.items.MAItemGroups;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.items.ItemInit;
import com.ma.items.armor.ISetItem;
import com.ma.tools.RLoc;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class FeyArmorItem
extends GeoArmorItem
implements IAnimatable,
ISetItem,
ITieredItem<FeyArmorItem>,
IFactionSpecific {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final ResourceLocation fey_armor_set_bonus = RLoc.create("fey_armor_set_bonus");
    public static final String fey_armor_set_bonus_key = "fey_armor_set_bonus";
    private static final float FLIGHT_MANA_COST_PER_TICK = 0.75f;
    private static final float HOVER_MANA_COST_PER_TICK = 0.25f;
    private int _tier = -1;
    public static LivingEntity renderEntity;

    public FeyArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder.func_200916_a(MAItemGroups.artifice).func_208103_a(Rarity.EPIC));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (renderEntity != null) {
            if (renderEntity.func_184613_cA() || renderEntity instanceof PlayerEntity && ((PlayerEntity)FeyArmorItem.renderEntity).field_71075_bZ.field_75100_b) {
                event.getController().transitionLengthTicks = 0.0;
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.fey_armor.flying"));
            } else {
                event.getController().transitionLengthTicks = 20.0;
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.fey_armor.notflying"));
            }
        } else {
            event.getController().transitionLengthTicks = 20.0;
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.fey_armor.notflying"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return fey_armor_set_bonus;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.usedByPlayer(player);
        if (stack.func_77973_b() == ItemInit.FEY_ARMOR_CHEST.get() && this.isSetEquipped((LivingEntity)player)) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                ManaAndArtifice.instance.proxy.setFlightEnabled(player, m.getCastingResource().getAmount() >= 0.25f);
                if (player.func_184812_l_()) {
                    ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.05f);
                } else {
                    ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.02f);
                }
                if (player.field_71075_bZ.field_75100_b) {
                    m.getCastingResource().consume(0.25f);
                    player.func_70031_b(false);
                }
            });
            if (player.func_110143_aJ() < player.func_110138_aP() * 0.1f && !player.func_184811_cZ().func_185141_a((Item)this)) {
                player.func_184811_cZ().func_185145_a((Item)this, 6000);
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 3, 60));
            }
        }
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(fey_armor_set_bonus_key, true);
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlotType ... setSlots) {
        if (living instanceof PlayerEntity) {
            living.getPersistentData().func_74757_a(fey_armor_set_bonus_key, false);
            ManaAndArtifice.instance.proxy.setFlightEnabled((PlayerEntity)living, false);
            ManaAndArtifice.instance.proxy.setFlySpeed((PlayerEntity)living, 0.05f);
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 4;
    }

    @Override
    public int getCachedtier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public Faction getFaction() {
        return Faction.FEY_COURT;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        Vector3d scaled_look;
        double lookScale;
        Vector3d motion;
        IPlayerMagic magic;
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        if (flightTicks % 100 == 0) {
            this.usedByPlayer((PlayerEntity)entity);
        }
        if ((magic = (IPlayerMagic)((PlayerEntity)entity).getCapability(PlayerMagicProvider.MAGIC).orElse(null)) == null || magic.getCastingResource().getAmount() < 0.75f) {
            return false;
        }
        Vector3d look = entity.func_70040_Z();
        if (!entity.func_225608_bj_()) {
            magic.getCastingResource().consume(0.75f);
            motion = entity.func_213322_ci();
            float maxLength = 1.75f;
            lookScale = 0.06;
            scaled_look = look.func_186678_a(lookScale);
            motion = motion.func_178787_e(scaled_look);
            if (motion.func_72433_c() > (double)maxLength) {
                motion = motion.func_186678_a((double)maxLength / motion.func_72433_c());
            }
            entity.func_213317_d(motion);
        } else {
            magic.getCastingResource().consume(0.5625f);
            motion = entity.func_213322_ci();
            float minLength = 0.1f;
            lookScale = -0.01;
            scaled_look = look.func_186678_a(lookScale);
            motion = motion.func_178787_e(scaled_look);
            if (motion.func_72433_c() < (double)minLength) {
                motion = motion.func_186678_a((double)minLength / motion.func_72433_c());
            }
            entity.func_213317_d(motion);
        }
        if (entity.field_70170_p.field_72995_K) {
            Vector3d pos = entity.func_213303_ch().func_178787_e(look.func_186678_a(3.0));
            for (int i = 0; i < 5; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())), pos.field_72450_a - 0.5 + Math.random(), pos.field_72448_b - 0.5 + Math.random(), pos.field_72449_c - 0.5 + Math.random(), -look.field_72450_a, -look.field_72448_b, -look.field_72449_c);
            }
        }
        return true;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return entity instanceof PlayerEntity && !entity.func_203005_aq() && !entity.func_180799_ab() && this.isSetEquipped(entity) && ((PlayerEntity)entity).getCapability(PlayerMagicProvider.MAGIC).isPresent() && ((IPlayerMagic)((PlayerEntity)entity).getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getCastingResource().getAmount() >= 0.75f;
    }

    public static boolean randomReflectChance() {
        return Math.random() < (Double)GeneralModConfig.MA_DRUIDIC_REFLECTCHANCE.get();
    }

    public static boolean randomTeleportChance() {
        return Math.random() < (Double)GeneralModConfig.MA_DRUIDIC_REFLECTCHANCE.get();
    }
}

