/*
 * Decompiled with CFR 0.152.
 */
package com.ma.items;

import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.MAItemGroups;
import com.ma.api.items.TieredItem;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralClientConfig;
import com.ma.gui.containers.providers.NamedGuideBook;
import com.ma.items.renderers.books.CodexBookRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LecternBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemGuideBook
extends TieredItem {
    private int guiOpenCount = 0;
    private long lastActivateTime = 0L;

    public ItemGuideBook() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(MAItemGroups.items).setISTER(() -> CodexBookRenderer::new));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack book = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND) {
            if (!world.field_72995_K) {
                if (!this.checkMagicUnlock((ServerWorld)world, player)) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new NamedGuideBook());
                }
            } else if (!((Boolean)GeneralClientConfig.PIN_TIP_SHOWN.get()).booleanValue()) {
                player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.getLastCodexRecipe() != null && p.getLastCodexRecipe().getKey() != null && p.getLastCodexRecipe().getValue() != null && !p.getLastCodexRecipe().getKey().isEmpty() && p.getLastCodexRecipe().getValue().length > 0) {
                        if (world.func_82737_E() - this.lastActivateTime < 200L) {
                            ++this.guiOpenCount;
                            if (this.guiOpenCount >= 4) {
                                GeneralClientConfig.PIN_TIP_SHOWN.set((Object)true);
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("helptip.mana-and-artifice.pin_recipe").func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
                            }
                        }
                    } else {
                        this.guiOpenCount = 0;
                    }
                    this.lastActivateTime = world.func_82737_E();
                });
            }
        }
        return ActionResult.func_226248_a_((Object)book);
    }

    public boolean checkMagicUnlock(ServerWorld world, PlayerEntity player) {
        IPlayerMagic playerMagic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (playerMagic != null && !playerMagic.isMagicUnlocked()) {
            if (world.func_73046_m().func_71264_H()) {
                world.func_241114_a_(world.func_82737_E() + 12000L);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.guide_book.magic_unlocked"), Util.field_240973_b_);
            playerMagic.setMagicLevel(1);
            world.func_184133_a(null, player.func_233580_cy_(), SFX.Event.Player.MAGIC_UNLOCKED, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (blockstate.func_203425_a(Blocks.field_222428_lQ)) {
            return LecternBlock.func_220151_a((World)world, (BlockPos)blockpos, (BlockState)blockstate, (ItemStack)context.func_195996_i()) ? ActionResultType.func_233537_a_((boolean)world.field_72995_K) : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }
}

