/*
 * Decompiled with CFR 0.152.
 */
package com.ma.inventory;

import com.ma.inventory.ItemInventoryBase;
import com.ma.items.filters.BottledWeaveItemFilter;
import com.ma.items.filters.MarkingRuneFilter;
import com.ma.items.filters.MoteItemFilter;
import com.ma.items.filters.RuneItemFilter;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.ritual.PractitionersPouchPatches;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryRitualKit
extends ItemInventoryBase {
    public static final int GENERAL_INVENTORY_START = 0;
    public static final int GENERAL_INVENTORY_END = 20;
    public static final int CONVEYANCE_INVENTORY_START = 21;
    public static final int CONVEYANCE_INVENTORY_END = 21;
    public static final int GLYPH_INVENTORY_START = 22;
    public static final int GLYPH_INVENTORY_END = 37;
    public static final int MOTE_INVENTORY_START = 38;
    public static final int MOTE_INVENTORY_END = 49;
    public static final int WEAVE_INVENTORY_START = 50;
    public static final int WEAVE_INVENTORY_END = 61;
    public static final int VOID_INVENTORY_START = 62;
    public static final int VOID_INVENTORY_END = 77;
    private final int slotLimit;

    public InventoryRitualKit(ItemStack bag) {
        super(bag, 78);
        int maxSize = ((ItemPractitionersPouch)bag.func_77973_b()).getPatchLevel(bag, PractitionersPouchPatches.DEPTH);
        this.slotLimit = maxSize >= 2 ? 2048 : (maxSize >= 1 ? 256 : 64);
    }

    @Override
    public int getSlotLimit(int slot) {
        if (slot >= 62 && slot <= 77) {
            return 1;
        }
        if (slot == 21) {
            return 1;
        }
        return this.slotLimit;
    }

    @Override
    public int getSlotLimit(int slot, ItemStack stack) {
        return stack.func_77985_e() ? this.getSlotLimit(slot) : 1;
    }

    private boolean isPatchEnabled(PractitionersPouchPatches patch) {
        return ((ItemPractitionersPouch)this.getStack().func_77973_b()).getPatchLevel(this.getStack(), patch) > 0;
    }

    public boolean canAddItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.CONVEYANCE) && new MarkingRuneFilter().IsValidItem(stack) && this.canAddItem(stack, 21, 21)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new RuneItemFilter().IsValidItem(stack) && this.canAddItem(stack, 22, 37)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new MoteItemFilter().IsValidItem(stack) && this.canAddItem(stack, 38, 49)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new BottledWeaveItemFilter().IsValidItem(stack) && this.canAddItem(stack, 50, 61)) {
            return true;
        }
        return this.canAddItem(stack, 0, 20);
    }

    protected boolean canAddItem(ItemStack stack, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            ItemStack invStack = this.getStackInSlot(i);
            if (!invStack.func_190926_b() && (!this.isSameItem(invStack, stack) || invStack.func_190916_E() >= invStack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public boolean canMergeItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.CONVEYANCE) && new MarkingRuneFilter().IsValidItem(stack) && this.canAddItem(stack, 21, 21)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new RuneItemFilter().IsValidItem(stack) && this.canAddItem(stack, 22, 37)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new MoteItemFilter().IsValidItem(stack) && this.canAddItem(stack, 38, 49)) {
            return true;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new BottledWeaveItemFilter().IsValidItem(stack) && this.canAddItem(stack, 50, 61)) {
            return true;
        }
        return this.canMergeItem(stack, 0, 20);
    }

    protected boolean canMergeItem(ItemStack stack, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            ItemStack invStack = this.getStackInSlot(i);
            if (!this.isSameItem(invStack, stack) || invStack.func_190916_E() >= this.getSlotLimit(i, invStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack opStack = stack.func_77946_l();
        if (this.isPatchEnabled(PractitionersPouchPatches.CONVEYANCE) && new MarkingRuneFilter().IsValidItem(opStack) && (opStack = this.addItem(opStack, 21, 21)).func_190926_b()) {
            return opStack;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.GLYPH) && new RuneItemFilter().IsValidItem(stack) && (opStack = this.addItem(opStack, 22, 37)).func_190926_b()) {
            return opStack;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.MOTE) && new MoteItemFilter().IsValidItem(stack) && (opStack = this.addItem(opStack, 38, 49)).func_190926_b()) {
            return opStack;
        }
        if (this.isPatchEnabled(PractitionersPouchPatches.WEAVE) && new BottledWeaveItemFilter().IsValidItem(stack) && (opStack = this.addItem(opStack, 50, 61)).func_190926_b()) {
            return opStack;
        }
        if (this.shouldVoidItem(opStack = this.mergeItem(opStack, 0, 20))) {
            return ItemStack.field_190927_a;
        }
        return opStack;
    }

    protected ItemStack mergeItem(ItemStack stack, int startSlot, int endSlot) {
        ItemStack itemstack = stack.func_77946_l();
        this.moveItemToOccupiedSlotsWithSameType(itemstack, startSlot, endSlot);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return itemstack;
    }

    protected ItemStack addItem(ItemStack stack, int startSlot, int endSlot) {
        ItemStack itemstack = stack.func_77946_l();
        this.moveItemToOccupiedSlotsWithSameType(itemstack, startSlot, endSlot);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.moveItemToEmptySlots(itemstack, startSlot, endSlot);
        return itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
    }

    protected void moveItemToOccupiedSlotsWithSameType(ItemStack stack, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!this.isSameItem(itemstack, stack)) continue;
            this.moveItemsBetweenStacks(stack, itemstack, i);
            if (!stack.func_190926_b()) continue;
            return;
        }
    }

    protected void moveItemToEmptySlots(ItemStack stack, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!itemstack.func_190926_b()) continue;
            this.setStackInSlot(i, stack.func_77946_l());
            stack.func_190920_e(0);
            return;
        }
    }

    public boolean containsItem(ItemStack stack, int startSlot, int endSlot) {
        for (int i = startSlot; i <= endSlot; ++i) {
            ItemStack invStack = this.getStackInSlot(i);
            if (!this.isSameItem(invStack, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldVoidItem(ItemStack stack) {
        if (!this.isPatchEnabled(PractitionersPouchPatches.VOID)) {
            return false;
        }
        return this.containsItem(stack, 62, 77);
    }

    @Override
    protected void moveItemsBetweenStacks(ItemStack source, ItemStack dest, int slot) {
        int i = this.getSlotLimit(slot, dest);
        int j = Math.min(source.func_190916_E(), i - dest.func_190916_E());
        if (j > 0) {
            dest.func_190917_f(j);
            source.func_190918_g(j);
            this.markDirty();
        }
    }

    public int countItem(Item item) {
        int count = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return count;
    }
}

