/*
 * Decompiled with CFR 0.152.
 */
package com.ma.interop.jei.categories;

import com.ma.api.capabilities.IPlayerProgression;
import com.ma.blocks.BlockInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.gui.GuiTextures;
import com.ma.interop.jei.RecipeCategoryUIDs;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.ma.tools.MATags;
import com.ma.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class RunicAnvilRecipeCategory
implements IRecipeCategory<RuneforgingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 144;
    private int ySize = 169;

    public RunicAnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.GUIDEBOOK_RECIPE_RUNESMITHING, 0, 0, this.xSize, this.ySize).setTextureSize(144, 169).build();
        this.localizedName = I18n.func_135052_a((String)"gui.mana-and-artifice.jei.runesmithing", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockInit.RUNIC_ANVIL.get()));
    }

    public ResourceLocation getUid() {
        return RecipeCategoryUIDs.RUNEFORGING;
    }

    public Class<? extends RuneforgingRecipe> getRecipeClass() {
        return RuneforgingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RuneforgingRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(Ingredient.func_234819_a_(MATags.smartLookupItem(recipe.getMaterial()).stream().map(i -> new ItemStack((IItemProvider)i))));
        inputs.add(Ingredient.func_234819_a_(MATags.smartLookupItem(recipe.getPatternResource()).stream().map(i -> new ItemStack((IItemProvider)i))));
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, RuneforgingRecipe recipe, IIngredients ingredients) {
        int x = 24;
        int y = 37;
        int reagentIdx = 0;
        for (List c : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(reagentIdx, true, x, y);
            recipeLayout.getItemStacks().set(reagentIdx, c);
            ++reagentIdx;
            y += 30;
        }
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            recipeLayout.getItemStacks().init(reagentIdx, false, 114, 55);
            recipeLayout.getItemStacks().set(reagentIdx, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public void draw(RuneforgingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.field_71439_g.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? ColorHelper.PackedColor.func_233006_a_((int)255, (int)0, (int)128, (int)0) : ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)0, (int)0);
            TranslationTextComponent name = new TranslationTextComponent(recipe.func_77571_b().func_77977_a().toString());
            TranslationTextComponent tierPrompt = new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier});
            int stringWidth = mc.field_71466_p.func_238414_a_((ITextProperties)name);
            int textX = this.xSize / 2 - stringWidth / 2;
            int textY = 5;
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)name, (float)textX, (float)textY, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
            mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)tierPrompt, (float)(this.xSize / 2 - mc.field_71466_p.func_238414_a_((ITextProperties)tierPrompt) / 2), 15.0f, color);
            GuiRenderUtils.renderFactionIcon(matrixStack, recipe.getFactionRequirement(), textX + stringWidth + 3, textY);
            String hits = String.format("x %d", recipe.getHits());
            mc.field_71466_p.func_238421_b_(matrixStack, I18n.func_135052_a((String)hits, (Object[])new Object[0]), (float)(this.xSize / 2 - mc.field_71466_p.func_78256_a(hits) / 2 + 10), 65.0f, ColorHelper.PackedColor.func_233006_a_((int)255, (int)71, (int)71, (int)71));
            RenderSystem.enableBlend();
        }
    }
}

