/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.slots;

import com.ma.gui.containers.slots.BaseSlot;
import com.ma.items.filters.ItemFilter;
import com.ma.items.filters.ItemFilterGroup;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class ItemFilterSlot
extends BaseSlot {
    private ItemFilterGroup itemType;
    private int maxStackSize = -1;
    private Consumer<Integer> changedCallback;
    private boolean active = true;

    public ItemFilterSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, ItemFilter validItems) {
        super(itemHandler, index, xPosition, yPosition);
        this.itemType = new ItemFilterGroup(validItems);
    }

    public ItemFilterSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, ItemFilterGroup validItems) {
        super(itemHandler, index, xPosition, yPosition);
        this.itemType = validItems;
    }

    public ItemFilterSlot setMaxStackSize(int stackSize) {
        this.maxStackSize = stackSize;
        return this;
    }

    public int func_75219_a() {
        return this.maxStackSize > 0 ? this.maxStackSize : super.func_75219_a();
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        boolean valid = this.itemType.anyMatchesFilter(stack);
        if (this.maxStackSize > 0) {
            valid &= stack.func_190916_E() <= this.maxStackSize;
        }
        return valid;
    }

    public void addChangeListener(Consumer<Integer> callback) {
        this.changedCallback = callback;
    }

    public void func_75218_e() {
        super.func_75218_e();
        if (this.changedCallback != null) {
            this.changedCallback.accept(this.getSlotIndex());
        }
    }

    public ItemStack func_75209_a(int amount) {
        if (this.changedCallback != null) {
            this.changedCallback.accept(this.getSlotIndex());
        }
        return super.func_75209_a(amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_111238_b() {
        return this.active;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setActive(boolean active) {
        this.active = active;
    }
}

