/*
 * Decompiled with CFR 0.152.
 */
package com.ma.gui.containers.item;

import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.gui.containers.ContainerInit;
import com.ma.items.ItemInit;
import com.ma.items.sorcery.ItemBookOfRote;
import com.ma.items.sorcery.ItemStaff;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class ContainerSpellAdjustments
extends Container {
    private final SpellRecipe recipe;
    private final ItemStack spellStack;
    private final Hand hand;

    public ContainerSpellAdjustments(int i, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(i, playerInventory);
    }

    public ContainerSpellAdjustments(int windowId, PlayerInventory playerInventory) {
        super(ContainerInit.SPELL_ADJUSTMENTS, windowId);
        this.hand = playerInventory.field_70458_d.func_184614_ca().func_77973_b() == ItemInit.SPELL.get() || playerInventory.field_70458_d.func_184614_ca().func_77973_b() instanceof ItemBookOfRote || playerInventory.field_70458_d.func_184614_ca().func_77973_b() instanceof ItemStaff ? Hand.MAIN_HAND : Hand.OFF_HAND;
        this.spellStack = playerInventory.field_70458_d.func_184586_b(this.hand);
        this.recipe = SpellRecipe.fromNBT(this.spellStack.func_196082_o());
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ModifiedSpellPart<Shape> getShape() {
        return this.recipe.getShape();
    }

    public ModifiedSpellPart<Component> getComponent() {
        return this.recipe.getComponent(0);
    }

    public Modifier getModifier(int index) {
        return this.recipe.getModifier(index);
    }

    public void increaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int steps = isShiftDown ? 5 : 1;
        for (int i = 0; i < steps; ++i) {
            if (part instanceof Shape) {
                this.getShape().stepUp(attribute);
                continue;
            }
            if (!(part instanceof Component)) continue;
            this.getComponent().stepUp(attribute);
        }
        this.recipe.calculateComplexity();
        this.recipe.calculateManaCost();
    }

    public void decreaseAttribute(IModifiable part, Attribute attribute, World world, boolean isShiftDown) {
        int steps = isShiftDown ? 5 : 1;
        for (int i = 0; i < steps; ++i) {
            if (part instanceof Shape) {
                this.getShape().stepDown(attribute);
                continue;
            }
            if (!(part instanceof Component)) continue;
            this.getComponent().stepDown(attribute);
        }
        this.recipe.calculateComplexity();
        this.recipe.calculateManaCost();
    }

    public float getManaCost(PlayerEntity player) {
        return this.recipe.getManaCost();
    }

    public float getComplexity(PlayerEntity player) {
        return this.recipe.getComplexity();
    }

    public ItemStack getSpellStack() {
        return this.spellStack;
    }

    public String getSpellName() {
        return this.spellStack.func_200301_q().getString();
    }

    public SpellRecipe getRecipe() {
        return this.recipe;
    }

    public Hand getHand() {
        return this.hand;
    }
}

