/*
 * Decompiled with CFR 0.152.
 */
package com.ma.events;

import com.ma.KeybindInit;
import com.ma.ManaAndArtifice;
import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.WellspringNode;
import com.ma.api.items.ITieredItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.effects.EffectHelper;
import com.ma.effects.EffectInit;
import com.ma.effects.interfaces.IDoubleTapEndEarly;
import com.ma.effects.interfaces.IInputDisable;
import com.ma.enchantments.EnchantmentInit;
import com.ma.entities.constructs.EntityBubbleBoat;
import com.ma.events.InputDisabler;
import com.ma.gui.GuiTextures;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.gui.radial.EnderDiscPatternSelectionScreen;
import com.ma.gui.radial.ItemstackSelectionWheel;
import com.ma.gui.radial.ModifierSelectionScreen;
import com.ma.gui.radial.RitualKitPatternSelectionScreen;
import com.ma.gui.radial.SpellSelectionScreen;
import com.ma.gui.widgets.PlayerInventoryButton;
import com.ma.items.IRadialInventorySelect;
import com.ma.items.ItemInit;
import com.ma.items.ritual.ItemPractitionersPouch;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.items.sorcery.ItemSpellBook;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.messages.to_server.PossessionInputMessage;
import com.ma.particles.types.movers.ParticleBezierMover;
import com.ma.particles.types.movers.ParticleOrbitMover;
import com.ma.tools.MATags;
import com.ma.tools.PosessionHelper;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.MARenderTypes;
import com.ma.tools.render.MultiblockRenderer;
import com.ma.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.glfw.GLFW;
import top.theillusivec4.curios.api.CuriosApi;

public class ClientEventHandler {
    private static boolean toolMenuKeyWasDown;
    private static boolean uiModifierKeyWasDown;
    public static boolean shiftPressed;
    private static float fogAmount;
    private static float fogDecay;
    public static int decrementFog;
    public static float[] fogColor;
    private static long spaceTapTimer;
    private static boolean lastTickJump;
    private static final ResourceLocation oredict_ores;

    public static void setFogAmount(float amount) {
        fogAmount = amount;
        decrementFog = 20;
    }

    public static float getFogAmount() {
        return fogAmount;
    }

    public static void wipeOpen() {
        Minecraft m = Minecraft.func_71410_x();
        m.field_195559_v.func_197967_a(false);
        while (KeybindInit.spellBookSelectWheelOpen.func_151468_f()) {
        }
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            boolean toolMenuKeyIsDown = KeybindInit.spellBookSelectWheelOpen.func_151470_d();
            if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
                while (KeybindInit.spellBookSelectWheelOpen.func_151468_f()) {
                    if (mc.field_71462_r != null) continue;
                    ItemStack inHand = mc.field_71439_g.func_184614_ca();
                    if (inHand.func_77973_b() instanceof ItemSpellBook) {
                        mc.func_147108_a((Screen)new SpellSelectionScreen());
                        continue;
                    }
                    if (inHand.func_77973_b() == ItemInit.MODIFIER_BOOK.get()) {
                        mc.func_147108_a((Screen)new ModifierSelectionScreen());
                        continue;
                    }
                    if (inHand.func_77973_b() == ItemInit.ENDER_DISK.get()) {
                        mc.func_147108_a((Screen)new EnderDiscPatternSelectionScreen());
                        continue;
                    }
                    if (inHand.func_77973_b() instanceof ItemPractitionersPouch) {
                        mc.func_147108_a((Screen)new RitualKitPatternSelectionScreen());
                        continue;
                    }
                    if (!(inHand.func_77973_b() instanceof IRadialInventorySelect)) continue;
                    mc.func_147108_a((Screen)new ItemstackSelectionWheel());
                }
            }
            toolMenuKeyWasDown = toolMenuKeyIsDown;
            boolean uiModifierKeyIsDown = KeybindInit.inventoryItemOpen.func_151470_d();
            if (uiModifierKeyIsDown != uiModifierKeyWasDown) {
                ClientMessageDispatcher.sendItemUIOpenMessage(uiModifierKeyIsDown);
                mc.field_71439_g.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.setModifierPressed(uiModifierKeyIsDown));
            }
            uiModifierKeyWasDown = uiModifierKeyIsDown;
        } else {
            toolMenuKeyWasDown = true;
            uiModifierKeyWasDown = true;
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        World world;
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player != null) {
            world = ManaAndArtifice.instance.proxy.getClientWorld();
            ClientEventHandler.renderWellsprings(world, player);
            if (player.func_70644_a((Effect)EffectInit.SNOWBLIND.get())) {
                double amount;
                double dist;
                fogDecay = 0.01f;
                if (fogAmount < fogDecay * 2.0f) {
                    fogAmount = fogDecay * 2.0f;
                }
                Vector3d pos = player.func_213303_ch();
                Vector3d lastPos = ManaAndArtifice.instance.proxy.getClientLastTickPosition();
                lastPos = new Vector3d(lastPos.field_72450_a, 0.0, lastPos.field_72449_c);
                pos = new Vector3d(pos.field_72450_a, 0.0, pos.field_72449_c);
                if (lastPos != Vector3d.field_186680_a && (dist = pos.func_72436_e(lastPos)) > 0.078 && (double)fogAmount < (amount = (dist - 0.078) * 10.0)) {
                    fogAmount = (float)amount;
                }
                if (fogAmount > 2.0f) {
                    fogAmount = 2.0f;
                }
            } else {
                fogDecay = 0.01f;
            }
        }
        if (fogAmount > 0.0f && decrementFog-- < 0) {
            fogAmount -= fogDecay;
        }
        ManaAndArtifice.instance.proxy.incrementTick();
        if (player != null && player.func_70644_a((Effect)EffectInit.CHOOSING_WELLSPRING.get())) {
            world = ManaAndArtifice.instance.proxy.getClientWorld();
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                int dist = (Integer)GeneralModConfig.MA_NODE_DISTANCE.get();
                int halfDist = dist / 2;
                HashMap<BlockPos, WellspringNode> nodes = m.getWellspringRegistry().getNearbyNodes(player.func_233580_cy_(), 50, dist + halfDist);
                Vector3d start = player.func_213303_ch();
                for (Map.Entry<BlockPos, WellspringNode> entry : nodes.entrySet()) {
                    BlockPos targetPos = entry.getKey();
                    Vector3d targetVec3d = new Vector3d((double)targetPos.func_177958_n(), player.func_226278_cu_() + 1.0, (double)targetPos.func_177952_p());
                    Vector3d dir = targetVec3d.func_178788_d(start).func_72432_b();
                    MAParticleType particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setScale(1.0f);
                    WellspringNode node = entry.getValue();
                    if (node.isClaimed()) {
                        int[] color = node.getAffinity().getShiftAffinity().getColor();
                        particle.setColor(color[0], color[1], color[2]);
                    } else {
                        particle.setColor(255, 255, 255);
                    }
                    world.func_195594_a((IParticleData)particle, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())), player.func_226277_ct_() + dir.func_82615_a() + Math.random() * 0.2 - 0.1, player.func_226278_cu_() + 1.0 + dir.func_82617_b() + Math.random() * 0.2 - 0.1, player.func_226281_cx_() + dir.func_82616_c() + Math.random() * 0.2 - 0.1, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                }
            });
        }
        if (player != null && player.func_70644_a((Effect)EffectInit.COLD_DARK.get())) {
            fogAmount = 0.95f;
            ClientEventHandler.fogColor[0] = 0.05f;
            ClientEventHandler.fogColor[1] = 0.05f;
            ClientEventHandler.fogColor[2] = 0.05f;
        }
    }

    private static void renderWellsprings(World world, PlayerEntity player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().getNearbyNodes(player.func_233580_cy_(), 0, 32).forEach((pos, node) -> {
            int i;
            float spread;
            if (!(node.isClaimed() || player.func_70644_a((Effect)EffectInit.ELDRIN_SIGHT.get()) || player.func_70644_a((Effect)EffectInit.WELLSPRING_SIGHT.get()))) {
                return;
            }
            if (node.hasForcedYLevel() && Math.abs(player.func_226278_cu_() - (double)node.getYLevel()) > 32.0) {
                return;
            }
            Affinity aff = node.getAffinity().getShiftAffinity();
            double yPos = node.hasForcedYLevel() ? (double)node.getYLevel() : player.func_226278_cu_();
            int[] colors = aff.getColor();
            int[] sparkleColors = null;
            float scale = 1.0f;
            float strength = node.getStrength();
            float lightSpread = spread = strength / 25.0f / 2.0f;
            int affPfxAmount = 2;
            float lightScale = 1.0f;
            float beamVelUp = 0.1f;
            int lightLifetime = 20;
            float[] velocities = new float[]{0.0f, 0.2f, 0.0f};
            Vector3d llPos = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            MAParticleType type = null;
            switch (aff) {
                case FIRE: 
                case HELLFIRE: {
                    type = (MAParticleType)ParticleInit.FLAME.get();
                    scale = 0.3f;
                    break;
                }
                case WATER: 
                case ICE: {
                    type = (MAParticleType)ParticleInit.WATER.get();
                    scale = 0.02f + (float)Math.random() * 0.04f;
                    spread = (float)((double)spread + 0.35);
                    lightScale = 0.75f;
                    break;
                }
                case EARTH: {
                    type = (MAParticleType)ParticleInit.DUST.get();
                    scale = 0.2f + (float)(Math.random() * (double)0.2f) * spread;
                    velocities = new float[]{0.0f, -0.13f, 0.0f};
                    sparkleColors = new int[]{30, 14, 10};
                    colors = new int[]{30, 14, 10};
                    affPfxAmount = 3;
                    lightScale = 0.625f * spread + 0.1f;
                    lightLifetime = 20;
                    beamVelUp = 0.01f;
                    lightSpread = 0.02f * spread;
                    if (!(Math.random() < (double)(spread + 0.25f))) break;
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())).setPhysics(false).setMaxAge(60).setScale(0.1f).setMover(new ParticleOrbitMover(llPos.func_82615_a(), yPos, llPos.func_82616_c(), 0.1, -0.025, 1.0f * spread)), llPos.func_82615_a(), yPos - 3.0 + Math.random() * 10.0, llPos.func_82616_c(), 0.0, 0.0, 0.0);
                    break;
                }
                case WIND: {
                    type = (MAParticleType)ParticleInit.AIR_ORBIT.get();
                    affPfxAmount = (int)Math.ceil(4.0f * spread);
                    scale = 0.0325f;
                    velocities = new float[]{0.3f, 0.2f, spread * 2.0f};
                    lightScale = 0.5f * spread + 0.15f;
                    beamVelUp = 0.2f;
                    spread *= 0.0f;
                    break;
                }
                case ENDER: {
                    type = (MAParticleType)ParticleInit.ENDER_VELOCITY.get();
                    scale = 0.3f;
                    lightScale = 0.4f;
                    lightSpread = 0.5f - lightSpread;
                    spread = 0.5f - spread;
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())).setPhysics(false).setMaxAge(60).setScale(0.1f).setMover(new ParticleOrbitMover(llPos.func_82615_a(), yPos, llPos.func_82616_c(), Math.random() * 0.1, Math.random() * 0.07, 0.4)), llPos.func_82615_a(), yPos - 3.0 + Math.random() * 10.0, llPos.func_82616_c(), 0.0, 0.0, 0.0);
                    break;
                }
                case ARCANE: {
                    type = (MAParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get();
                    scale = 0.15f;
                    affPfxAmount = 3;
                    colors = new int[]{102, 32, 232};
                    lightSpread = 0.05f;
                    if (player.field_70170_p.func_82737_E() % 20L != 0L) break;
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setColor(colors[0], colors[1], colors[2]).setPhysics(false).setMaxAge(60), llPos.func_82615_a(), yPos - 4.0, llPos.func_82616_c(), 0.25, 0.25, (double)spread);
                }
            }
            for (i = 0; i < 15; ++i) {
                world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setScale(lightScale).setColor(colors[0], colors[1], colors[2]).setMaxAge(lightLifetime), llPos.func_82615_a() - (double)lightSpread + Math.random() * (double)lightSpread * 2.0, yPos - 3.0 + Math.random() * 10.0, llPos.func_82616_c() - (double)lightSpread + Math.random() * (double)lightSpread * 2.0, 0.0, (double)beamVelUp, 0.0);
            }
            if (type != null) {
                for (i = 0; i < affPfxAmount; ++i) {
                    MAParticleType particle = new MAParticleType(type).setScale(scale).setPhysics(false);
                    if (sparkleColors != null) {
                        particle.setColor((int)sparkleColors[0], (int)sparkleColors[1], (int)sparkleColors[2]);
                    }
                    world.func_195594_a((IParticleData)particle, llPos.func_82615_a() - (double)spread + Math.random() * (double)spread * 2.0, yPos - 3.0 + Math.random() * 10.0, llPos.func_82616_c() - (double)spread + Math.random() * (double)spread * 2.0, (double)velocities[0], (double)velocities[1], (double)velocities[2]);
                }
            }
            if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                if (!node.hasForcedYLevel()) {
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setColor(colors[0], colors[1], colors[2]), llPos.func_82615_a(), yPos - 1.0, llPos.func_82616_c(), 0.25, 0.25, 0.65);
                } else {
                    int rnd = (int)(Math.random() * 4.0);
                    Vector3d start = new Vector3d(llPos.func_82615_a() - 0.5, yPos - 2.0, llPos.func_82616_c() - 0.5);
                    Vector3d end = null;
                    Vector3d control_a = null;
                    Vector3d control_b = null;
                    switch (rnd) {
                        case 0: {
                            end = new Vector3d(llPos.func_82615_a(), yPos + 2.0, llPos.func_82616_c() + 5.0);
                            control_a = new Vector3d(llPos.func_82615_a(), yPos + 4.0, llPos.func_82616_c() + 1.0);
                            control_b = new Vector3d(llPos.func_82615_a(), yPos + 4.0, llPos.func_82616_c() + 3.0);
                            break;
                        }
                        case 1: {
                            end = new Vector3d(llPos.func_82615_a() + 5.0, yPos + 2.0, llPos.func_82616_c());
                            control_a = new Vector3d(llPos.func_82615_a() + 1.0, yPos + 4.0, llPos.func_82616_c());
                            control_b = new Vector3d(llPos.func_82615_a() + 3.0, yPos + 4.0, llPos.func_82616_c());
                            break;
                        }
                        case 2: {
                            end = new Vector3d(llPos.func_82615_a() - 5.0, yPos + 2.0, llPos.func_82616_c());
                            control_a = new Vector3d(llPos.func_82615_a() - 1.0, yPos + 4.0, llPos.func_82616_c());
                            control_b = new Vector3d(llPos.func_82615_a() - 3.0, yPos + 4.0, llPos.func_82616_c());
                            break;
                        }
                        case 3: {
                            end = new Vector3d(llPos.func_82615_a(), yPos + 2.0, llPos.func_82616_c() - 5.0);
                            control_a = new Vector3d(llPos.func_82615_a(), yPos + 4.0, llPos.func_82616_c() - 1.0);
                            control_b = new Vector3d(llPos.func_82615_a(), yPos + 4.0, llPos.func_82616_c() - 3.0);
                        }
                    }
                    world.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_BEZIER.get())).setColor(colors[0], colors[1], colors[2]).setMaxAge(30).setAgePadding(5).setScale(0.2f).setMover(new ParticleBezierMover(start, end, control_a, control_b)), start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
                }
            }
        }));
    }

    @SubscribeEvent
    public static void onMouseClick(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        EffectInstance posession = mc.field_71439_g.func_70660_b((Effect)EffectInit.POSSESSION.get());
        if (event.isAttack() && posession != null && posession.func_76458_c() > 0) {
            event.setCanceled(true);
            ClientMessageDispatcher.sendPosessionClickInput();
        }
    }

    @SubscribeEvent
    public static void playerInputEvent(InputUpdateEvent event) {
        EffectInstance posession;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (spaceTapTimer > 0L) {
            --spaceTapTimer;
        }
        if ((posession = mc.field_71439_g.func_70660_b((Effect)EffectInit.POSSESSION.get())) != null && posession.func_76458_c() > 0) {
            int id;
            Entity e2;
            ClientMessageDispatcher.sendPosessionMovementInput(event.getMovementInput().field_187255_c ? 1.0f : (event.getMovementInput().field_187256_d ? -1.0f : 0.0f), event.getMovementInput().field_187257_e ? 1.0f : (event.getMovementInput().field_187258_f ? -1.0f : 0.0f), event.getMovementInput().field_78901_c, event.getMovementInput().field_228350_h_, mc.field_71439_g.field_70177_z, mc.field_71439_g.field_70759_as, mc.field_71439_g.field_70125_A);
            PossessionInputMessage msg = PossessionInputMessage.movement(event.getMovementInput().field_187255_c ? 1.0f : (event.getMovementInput().field_187256_d ? -1.0f : 0.0f), event.getMovementInput().field_187257_e ? 1.0f : (event.getMovementInput().field_187258_f ? -1.0f : 0.0f), event.getMovementInput().field_78901_c, event.getMovementInput().field_228350_h_, mc.field_71439_g.field_70177_z, mc.field_71439_g.field_70759_as, mc.field_71439_g.field_70125_A);
            if (mc.field_71439_g.getPersistentData().func_74764_b("posessed_entity_id") && (e2 = mc.field_71439_g.field_70170_p.func_73045_a(id = mc.field_71439_g.getPersistentData().func_74762_e("posessed_entity_id"))) != null && e2 instanceof MobEntity) {
                PosessionHelper.handleRemoteInput(msg, (PlayerEntity)mc.field_71439_g, (MobEntity)e2);
            }
        }
        if (!mc.field_71439_g.func_233570_aj_() && event.getMovementInput().field_78901_c && mc.field_71439_g.field_70773_bE == 0) {
            ItemStack boots = mc.field_71439_g.func_184582_a(EquipmentSlotType.FEET);
            int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentInit.LEAPING.get()), (ItemStack)boots);
            if (!boots.func_190926_b() && enchLevel > 0) {
                mc.field_71439_g.field_70773_bE = 10;
                ClientMessageDispatcher.sendPlayerJump();
            }
        }
        if (!lastTickJump && event.getMovementInput().field_78901_c && mc.field_71439_g.func_70651_bq().stream().anyMatch(e -> e.func_188419_a() instanceof IDoubleTapEndEarly)) {
            if (spaceTapTimer == 0L) {
                spaceTapTimer = 7L;
            } else {
                EffectHelper.removeDoubleTapEvents((PlayerEntity)mc.field_71439_g);
                ClientMessageDispatcher.sendRequestEndControlEffectEarlyMessage();
                spaceTapTimer = 0L;
            }
        }
        lastTickJump = event.getMovementInput().field_78901_c;
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getPlayer());
        if ((mask & IInputDisable.InputMask.MOVEMENT.mask()) != 0) {
            event.getMovementInput().field_187255_c = false;
            event.getMovementInput().field_187256_d = false;
            event.getMovementInput().field_187257_e = false;
            event.getMovementInput().field_187258_f = false;
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_192832_b = 0.0f;
            event.getMovementInput().field_78902_a = 0.0f;
            event.getMovementInput().field_228350_h_ = false;
        }
    }

    public static boolean isKeyDown(KeyBinding keybind) {
        if (keybind.func_197986_j()) {
            return false;
        }
        boolean isDown = false;
        switch (keybind.getKey().func_197938_b()) {
            case KEYSYM: {
                isDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybind.getKey().func_197937_c());
                break;
            }
            case MOUSE: {
                isDown = GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybind.getKey().func_197937_c()) == 1;
            }
        }
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent rwl) {
        MatrixStack matrixStack = rwl.getMatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d projectedView = mc.field_71460_t.func_215316_n().func_216785_c();
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        ClientEventHandler.renderMarkingRunes(mc, matrixStack, projectedView, buffers);
        EffectInstance inst = mc.field_71439_g.func_70660_b((Effect)EffectInit.DIVINATION.get());
        if (inst != null) {
            ClientEventHandler.renderNearbyOres(mc, matrixStack, projectedView, buffers, inst.func_76458_c() + 2);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        ClientEventHandler.renderDistantWellsprings((World)mc.field_71441_e, mc.func_184121_ak(), matrixStack, (IRenderTypeBuffer)buffers, (PlayerEntity)mc.field_71439_g);
        matrixStack.func_227865_b_();
        buffers.func_228461_a_();
    }

    private static void renderDistantWellsprings(World world, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, PlayerEntity player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().getNearbyNodes(player.func_233580_cy_(), 0, 128).forEach((pos, node) -> {
            double distAdjusted;
            double distPct;
            if (!(node.isClaimed() || player.func_70644_a((Effect)EffectInit.ELDRIN_SIGHT.get()) || player.func_70644_a((Effect)EffectInit.WELLSPRING_SIGHT.get()))) {
                return;
            }
            if (node.hasForcedYLevel() && Math.abs(player.func_226278_cu_() - (double)node.getYLevel()) > 32.0) {
                return;
            }
            double dist = Math.sqrt(player.func_233580_cy_().func_177951_i((Vector3i)pos));
            Affinity aff = node.getAffinity().getShiftAffinity();
            int alpha = 176;
            int distFalloff = 12;
            int distFalloffStart = 38;
            int height = 13;
            if (dist < (double)distFalloffStart && aff != Affinity.ENDER && aff != Affinity.WIND && (alpha = (int)((double)alpha * (distPct = 1.0 - (distAdjusted = (double)distFalloffStart - dist) / (double)distFalloff))) < 0) {
                alpha = 0;
            }
            if (!node.hasForcedYLevel() && dist > (double)distFalloffStart) {
                height = 255;
            }
            int[] color = aff.getColor();
            double yPos = node.hasForcedYLevel() ? (double)(node.getYLevel() - 4) : (dist < (double)distFalloffStart ? player.func_226278_cu_() - 3.0 : 0.0);
            Vector3d llPos = new Vector3d((double)pos.func_177958_n() + 0.5, yPos, (double)pos.func_177952_p() + 0.5);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(llPos.field_72450_a, llPos.field_72448_b, llPos.field_72449_c);
            WorldRenderUtils.renderBeam(world, partialTicks, matrixStack, buffer, 0xF00000, llPos, llPos.func_72441_c(0.0, (double)height, 0.0), 1.0f, color, alpha, 0.25f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
            matrixStack.func_227865_b_();
        }));
    }

    private static void renderMarkingRunes(Minecraft mc, MatrixStack matrixStack, Vector3d projectedView, IRenderTypeBuffer.Impl buffers) {
        Vector3d offsetVec;
        float offsetAmt;
        Direction face;
        int drawDist = 4096;
        ItemStack mainHand = mc.field_71439_g.func_184614_ca();
        ItemStack offHand = mc.field_71439_g.func_184592_cb();
        BlockPos mainHandPos = null;
        BlockPos offhandPos = null;
        boolean render = false;
        if (mainHand.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            mainHandPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(mainHand);
            render = true;
        }
        if (offHand.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            offhandPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(offHand);
            render = true;
        }
        if (!render) {
            return;
        }
        boolean drawMainHand = false;
        boolean drawOffHand = false;
        RenderSystem.disableDepthTest();
        if (mainHandPos != null && mc.field_71439_g.func_70092_e((double)mainHandPos.func_177958_n(), (double)mainHandPos.func_177956_o(), (double)mainHandPos.func_177952_p()) < (double)drawDist) {
            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)new AxisAlignedBB(mainHandPos).func_186664_h(0.25), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            face = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(mainHand);
            offsetAmt = 0.4f;
            offsetVec = new Vector3d((double)((float)face.func_82601_c() * offsetAmt), (double)((float)face.func_96559_d() * offsetAmt), (double)((float)face.func_82599_e() * offsetAmt));
            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)new AxisAlignedBB(mainHandPos).func_191194_a(offsetVec).func_186664_h(0.49).func_191195_a(-offsetVec.field_72450_a, -offsetVec.field_72448_b, -offsetVec.field_72449_c), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawMainHand = true;
        }
        if (offhandPos != null && mc.field_71439_g.func_70092_e((double)offhandPos.func_177958_n(), (double)offhandPos.func_177956_o(), (double)offhandPos.func_177952_p()) < (double)drawDist) {
            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)new AxisAlignedBB(offhandPos).func_186664_h(0.25), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            face = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(offHand);
            offsetAmt = 0.4f;
            offsetVec = new Vector3d((double)((float)face.func_82601_c() * offsetAmt), (double)((float)face.func_96559_d() * offsetAmt), (double)((float)face.func_82599_e() * offsetAmt));
            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)new AxisAlignedBB(offhandPos).func_191194_a(offsetVec).func_186664_h(0.49).func_191195_a(-offsetVec.field_72450_a, -offsetVec.field_72448_b, -offsetVec.field_72449_c), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawOffHand = true;
        }
        if (drawMainHand && drawOffHand) {
            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)MathUtils.createInclusiveBB(mainHandPos, offhandPos), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.enableDepthTest();
    }

    private static void renderNearbyOres(Minecraft mc, MatrixStack matrixStack, Vector3d projectedView, IRenderTypeBuffer.Impl buffers, int radius) {
        ItemStack offhand = mc.field_71439_g.func_184592_cb();
        boolean searchOffhand = offhand.func_77973_b() instanceof BlockItem;
        BlockPos origin = mc.field_71439_g.func_233580_cy_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos target = origin.func_177982_a(x, y, z);
                    BlockState state = mc.field_71441_e.func_180495_p(target);
                    if ((!searchOffhand || state.func_177230_c() != ((BlockItem)offhand.func_77973_b()).func_179223_d()) && (searchOffhand || !(state.func_177230_c() instanceof OreBlock) && !MATags.isBlockIn(state.func_177230_c(), oredict_ores))) continue;
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffers.getBuffer(MARenderTypes.MARKING_RUNE_MARK), (AxisAlignedBB)new AxisAlignedBB(target), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderBlockOverlayEvent event) {
        if (event.getBlockForOverlay().func_177230_c() == Blocks.field_150480_ab) {
            Entity ridingEntity = event.getPlayer().func_184187_bx();
            if (ridingEntity != null && ridingEntity instanceof EntityBubbleBoat && ((EntityBubbleBoat)ridingEntity).isBrimstone()) {
                event.setCanceled(true);
            } else if (event.getPlayer().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ItemInit.BRIMSTONE_BOAT.get()) {
                event.setCanceled(true);
            } else if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.EMBERGLOW_BRACELET.get(), (LivingEntity)event.getPlayer()).isPresent()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen screen = evt.getGui();
        if (screen instanceof InventoryScreen || screen instanceof CreativeScreen) {
            boolean isCreative = screen instanceof CreativeScreen;
            Tuple<Integer, Integer> offsets = PlayerInventoryButton.getOffsets(isCreative);
            int x = (Integer)offsets.func_76341_a();
            int y = (Integer)offsets.func_76340_b();
            int textureOffsetX = 6;
            ContainerScreen gui = (ContainerScreen)screen;
            if (HUDOverlayRenderer.instance.getPinnedrecipe() != null) {
                evt.addWidget((Widget)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.field_230709_l_ / 2 + y, 5, 10, textureOffsetX, 27, 10, GuiTextures.WIDGETS, button -> {
                    HUDOverlayRenderer.instance.setPinnedRecipe(null);
                    button.field_230693_o_ = false;
                    button.field_230694_p_ = false;
                }, (button, stack, mouseX, mouseY) -> gui.func_238652_a_(stack, button.func_230458_i_(), mouseX, mouseY), (ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.clear_pinned_prompt")));
            }
            if (MultiblockRenderer.hasMultiblock) {
                evt.addWidget((Widget)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.field_230709_l_ / 2 + y + 10, 5, 5, textureOffsetX, 47, 5, GuiTextures.WIDGETS, button -> MultiblockRenderer.setMultiblock(null, null, true), (button, stack, mouseX, mouseY) -> gui.func_238652_a_(stack, button.func_230458_i_(), mouseX, mouseY), (ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.clear_multiblock_prompt")));
                evt.addWidget((Widget)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.field_230709_l_ / 2 + y + 20, 5, 5, textureOffsetX, 57, 5, GuiTextures.WIDGETS, button -> MultiblockRenderer.toggleLowestLayerMode(), (button, stack, mouseX, mouseY) -> gui.func_238652_a_(stack, button.func_230458_i_(), mouseX, mouseY), (ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.multiblock_mode_prompt")));
            }
        }
    }

    @SubscribeEvent
    public static void onFogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (fogAmount > 0.0f) {
            float f1 = MathHelper.func_219799_g((float)Math.min(1.0f, fogAmount), (float)event.getFarPlaneDistance(), (float)5.0f);
            float f2 = 0.0f;
            float f3 = f1 * 0.8f;
            RenderSystem.fogStart((float)f2);
            RenderSystem.fogEnd((float)f3);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            RenderSystem.setupNvFogDistance();
        }
    }

    @SubscribeEvent
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (fogAmount > 0.0f) {
            event.setRed(fogColor[0]);
            event.setGreen(fogColor[1]);
            event.setBlue(fogColor[2]);
        }
    }

    @SubscribeEvent
    public static void onTooltipRender(ItemTooltipEvent event) {
        World world = ManaAndArtifice.instance.proxy.getClientWorld();
        if (world != null && event.getItemStack().func_77973_b() instanceof ITieredItem) {
            if (event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("hideTier")) {
                return;
            }
            ITieredItem item = (ITieredItem)event.getItemStack().func_77973_b();
            int tier = item.getTier(world, event.getItemStack());
            if (tier == -2) {
                event.getToolTip().add(new TranslationTextComponent("gui.mana-and-artifice.item-tier.none").func_240699_a_(TextFormatting.GREEN));
            } else {
                MutableBoolean metTier = new MutableBoolean(false);
                if (tier > 0) {
                    PlayerEntity clientPlayer = ManaAndArtifice.instance.proxy.getClientPlayer();
                    if (clientPlayer != null) {
                        clientPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                            if (p.getTier() >= tier) {
                                metTier.setTrue();
                            }
                        });
                    }
                    event.getToolTip().add(new TranslationTextComponent("gui.mana-and-artifice.item-tier", new Object[]{tier}).func_240699_a_(metTier.getValue() != false ? TextFormatting.GREEN : TextFormatting.RED));
                } else {
                    event.getToolTip().add(new TranslationTextComponent("gui.mana-and-artifice.item-tier.none").func_240699_a_(TextFormatting.GREEN));
                }
            }
        }
    }

    static {
        shiftPressed = false;
        fogAmount = 0.0f;
        fogDecay = 0.01f;
        decrementFog = 0;
        fogColor = new float[]{1.0f, 1.0f, 1.0f};
        spaceTapTimer = 0L;
        lastTickJump = false;
        oredict_ores = new ResourceLocation("forge", "ores");
    }
}

