/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.rituals.IRitualReagent;
import com.ma.api.rituals.RitualBlockPos;
import com.ma.api.rituals.RitualEffect;
import com.ma.api.sound.SFX;
import com.ma.blocks.BlockInit;
import com.ma.blocks.ritual.ChalkRuneBlock;
import com.ma.blocks.tileentities.ChalkRuneTile;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.entities.manaweaving.EntityManaweave;
import com.ma.entities.utility.EntityResidualMagic;
import com.ma.events.EventDispatcher;
import com.ma.network.ServerMessageDispatcher;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.rituals.RitualBlockPosComparator;
import com.ma.rituals.RitualInit;
import com.ma.rituals.RitualReagent;
import com.ma.rituals.contexts.RitualContext;
import com.ma.rituals.contexts.RitualReagentReplaceContext;
import com.ma.sound.EntityAliveLoopingSound;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityRitual
extends Entity {
    private static final DataParameter<CompoundNBT> BLOCK_LOCATIONS = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> VALID_LOCATIONS = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> COLLECTED_REAGENTS = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Byte> RITUAL_STATE = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> SHUTDOWN_AGE = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> RITUAL_NAME = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> CASTER_UUID = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> REQUESTED_PATTERN = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> CURRENT_ENTITY = EntityDataManager.func_187226_a(EntityRitual.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final byte MODE_ALL = 0;
    public static final byte MODE_INDEXED = 1;
    public static final byte MODE_INDEXED_DISPLAY = 2;
    public static final int REAGENT_ADVANCE_RATE = 20;
    public static final int RADIANT_ADVANCE_RATE = 10;
    public static final int BEAM_ADVANCE_RATE = 3;
    public static final float SPEED_NORMAL = 1.0f;
    public static float SPEED_FAST = 0.1f;
    private int age = 0;
    private int stageTicks = 0;
    final RitualBlockPosComparator comp;
    private NonNullList<Pair<BlockPos, ItemStack>> collectedReagents;
    private NonNullList<ResourceLocation> collectedPatterns;
    private NonNullList<ResourceLocation> requiredPatterns;
    private RitualState prevState;
    private RitualState curState;
    private boolean forceCollectAllReagents = false;
    private Entity __patternEntity;
    private int patternConsumeTicks = 0;
    private int dispatchTries = 0;
    private NonNullList<RitualEffect> __cachedRitualHandlers;
    private RitualRecipe __cachedCurrentRitual;
    private boolean __dynamicReagentsCached = false;
    public long worldTimeAtReagentCollectStart = 0L;
    private ItemStack cachedDynamicStack = ItemStack.field_190927_a;
    private boolean dynamicItemChanged = false;

    public EntityRitual(EntityType<? extends EntityRitual> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
        this.comp = new RitualBlockPosComparator();
        this.collectedReagents = NonNullList.func_191196_a();
        this.collectedPatterns = NonNullList.func_191196_a();
        this.requiredPatterns = NonNullList.func_191196_a();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void runStateLogic() {
        switch (this.curState) {
            case POWERING_UP: {
                this.logic_statePoweringUp();
                break;
            }
            case COLLECTING_REAGENTS: {
                this.logic_stateGatheringReagents();
                break;
            }
            case COLLECTING_PATTERNS: {
                this.logic_stateGatheringPatterns();
                break;
            }
            case COLLAPSING: {
                this.logic_collapsing();
                break;
            }
            case PROCESSING_RITUAL: {
                this.logic_processRitual();
                break;
            }
            case COMPLETING: {
                this.logic_complete();
                break;
            }
        }
    }

    private void logic_statePoweringUp() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(true);
        }
        if (this.getStageTicks() >= this.getPowerupTime()) {
            this.setState(RitualState.COLLECTING_REAGENTS);
        }
    }

    private void logic_stateGatheringReagents() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(false);
        }
        if (this.getStageTicks() == 10) {
            NonNullList<RitualBlockPos> locations = this.getRitualData((byte)1);
            for (RitualBlockPos rbp : locations) {
                TileEntity te = this.field_70170_p.func_175625_s(rbp.getBlockPos());
                if (te == null || !(te instanceof ChalkRuneTile)) continue;
                ChalkRuneTile teCr = (ChalkRuneTile)te;
                if (rbp.isPresent() && !rbp.getReagent().isEmpty()) {
                    if (teCr.MatchesReagent(rbp.getReagent().getResourceLocation())) {
                        if (rbp.getReagent().shouldConsumeReagent() || rbp.getReagent().isManualReturn() || this.forceCollectAllReagents) {
                            ItemStack stack = teCr.func_70301_a(0).func_77946_l();
                            teCr.clearStack();
                            this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)stack));
                            BlockState state = this.field_70170_p.func_180495_p(rbp.getBlockPos());
                            this.field_70170_p.func_184138_a(rbp.getBlockPos(), state, state, 2);
                        } else {
                            this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)teCr.func_70301_a(0).func_77946_l()));
                        }
                    } else {
                        this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)new ItemStack((IItemProvider)Items.field_190931_a)));
                    }
                }
                teCr.setReadOnly(true);
            }
            if (!this.field_70170_p.field_72995_K) {
                ListNBT list = this.writeCollectedReagents();
                CompoundNBT compound = new CompoundNBT();
                compound.func_218657_a("data", (INBT)list);
                this.field_70180_af.func_187227_b(COLLECTED_REAGENTS, (Object)compound);
                ServerMessageDispatcher.sendRitualReagentData(compound, this.func_145782_y(), (ServerWorld)this.field_70170_p, this.func_233580_cy_());
            }
        }
        if (this.getStageTicks() >= 40) {
            this.setState(RitualState.COLLECTING_PATTERNS);
        }
    }

    private void logic_stateGatheringPatterns() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(false);
        }
        if (this.requiredPatterns.size() == 0) {
            this.setState(RitualState.COLLAPSING);
            return;
        }
        ManaweavingPattern pattern = this.getRequestedPattern();
        if (pattern == null) {
            this.setRequestedPattern(((ResourceLocation)this.requiredPatterns.get(0)).toString());
            return;
        }
        if (this.getCurrentEntityTarget() == null) {
            if (this.getAge() % 10 == 0) {
                this.findPatternEntity();
            }
        } else {
            ++this.patternConsumeTicks;
            if (this.patternConsumeTicks >= 20) {
                this.getCurrentEntityTarget().remove(false);
                this.setRequestedPattern("");
                this.patternConsumeTicks = 0;
                this.collectedPatterns.add(this.requiredPatterns.get(0));
                this.requiredPatterns.remove(0);
            }
        }
    }

    private void logic_collapsing() {
        if (this.getStageTicks() >= 20) {
            this.setState(RitualState.PROCESSING_RITUAL);
        }
    }

    private void logic_processRitual() {
        PlayerEntity ritualCaster = this.getCaster();
        if (ritualCaster != null || this.dispatchTries >= 10) {
            if (ritualCaster == null) {
                ManaAndArtifice.LOGGER.error("Failed to parse UUID for ritual caster.  Giving up and completing the ritual anyway, but some effects may not apply!");
            }
            for (RitualEffect eff : this.getHandlers()) {
                eff.onRitualCompleted(new RitualContext(this.getCaster(), this));
            }
        } else {
            ++this.dispatchTries;
            return;
        }
        int shutdownTime = 0;
        for (RitualEffect eff : this.getHandlers()) {
            int time = eff.getRitualCompleteDelay(new RitualContext(this.getCaster(), this));
            if (time <= shutdownTime) continue;
            shutdownTime = time;
        }
        if (shutdownTime < 0) {
            shutdownTime = 0;
        }
        this.setShutdownAge(shutdownTime);
        this.setState(RitualState.COMPLETING);
    }

    private void logic_complete() {
        if (this.func_70089_S() && this.getStageTicks() > this.getShutdownAge()) {
            NonNullList<RitualBlockPos> positions = this.getRitualData((byte)0);
            for (int i = 0; i < positions.size(); ++i) {
                ChalkRuneTile tecr;
                BlockState runeState = this.field_70170_p.func_180495_p(((RitualBlockPos)positions.get(i)).getBlockPos());
                if (runeState.func_177230_c() != BlockInit.CHALK_RUNE.get() || (tecr = (ChalkRuneTile)this.field_70170_p.func_175625_s(((RitualBlockPos)positions.get(i)).getBlockPos())) == null) continue;
                if (((Boolean)runeState.func_177229_b((Property)ChalkRuneBlock.METAL)).booleanValue()) {
                    tecr.setReadOnly(false);
                    this.field_70170_p.func_175656_a(((RitualBlockPos)positions.get(i)).getBlockPos(), (BlockState)runeState.func_206870_a((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (!tecr.isGhostItem()) {
                    InventoryHelper.func_180175_a((World)this.field_70170_p, (BlockPos)((RitualBlockPos)positions.get(i)).getBlockPos(), (IInventory)tecr);
                }
                this.field_70170_p.func_175656_a(((RitualBlockPos)positions.get(i)).getBlockPos(), Blocks.field_150350_a.func_176223_P());
            }
            if (this.getCurrentRitual() != null && this.getCaster() != null) {
                EventDispatcher.DispatchRitualComplete(this.getCurrentRitual(), this.getHandlers(), this.func_233580_cy_(), this.collectedReagents.stream().map(e -> (ItemStack)e.getSecond()).collect(Collectors.toList()), this.getCaster());
                this.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> this.getCaster().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.addMagicXP(10, this.getCaster(), (IPlayerProgression)p)));
            }
            this.field_70170_p.func_217376_c((Entity)new EntityResidualMagic(this.field_70170_p, this.func_233580_cy_().func_177982_a(0, 2, 0), this.__cachedCurrentRitual != null ? (float)(this.__cachedCurrentRitual.getLowerBound() * 50) : 50.0f));
            this.remove(false);
        }
    }

    public void func_70071_h_() {
        this.prevState = this.curState;
        this.curState = this.getState();
        this.setStageTicks(this.getStageTicks() + 1);
        if (this.curState == RitualState.GUIDING_REAGENT_PLACEMENT) {
            if (!this.field_70170_p.field_72995_K && !this.__dynamicReagentsCached && this.stageTicks % 20 == 0) {
                this.checkRitualIntegrity(true);
            }
            return;
        }
        this.setAge(this.getAge() + 1);
        if (this.prevState != this.curState) {
            this.setStageTicks(0);
        }
        if (this.field_70170_p.field_72995_K) {
            this.SpawnParticles();
            this.PlaySounds();
        } else {
            this.runStateLogic();
        }
    }

    public boolean confirmRitualReagents() {
        if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
            return false;
        }
        boolean canStart = true;
        ArrayList<BlockPos> validLocations = new ArrayList<BlockPos>();
        NonNullList<RitualBlockPos> ritualData = this.getRitualData((byte)1, true);
        if (this.dynamicItemChanged) {
            this.cancelRitual(true);
            return false;
        }
        for (RitualBlockPos pos : ritualData) {
            if (!pos.isPresent() || pos.getReagent().isOptional() || !this.field_70170_p.func_195588_v(pos.getBlockPos())) continue;
            ChalkRuneTile te = (ChalkRuneTile)this.field_70170_p.func_175625_s(pos.getBlockPos());
            if (te == null) {
                return false;
            }
            boolean match = te.MatchesReagent(pos.getReagent().getResourceLocation());
            if (match) {
                validLocations.add(pos.getBlockPos());
            }
            canStart &= match;
        }
        this.setValidReagentLocations(validLocations);
        if (canStart) {
            this.setState(RitualState.POWERING_UP);
        }
        return canStart;
    }

    @Nullable
    public IRitualReagent getReagentForPosition(BlockPos pos) {
        if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
            return null;
        }
        Optional<RitualBlockPos> dataPos = this.getRitualData((byte)1).stream().filter(rbp -> rbp.getBlockPos().equals((Object)pos)).findFirst();
        if (dataPos.isPresent() && this.field_70170_p.func_195588_v(pos)) {
            ChalkRuneTile te = (ChalkRuneTile)this.field_70170_p.func_175625_s(dataPos.get().getBlockPos());
            if (te == null) {
                return null;
            }
            return dataPos.get().getReagent();
        }
        return null;
    }

    public boolean checkForExplosion(boolean checkReagents) {
        if (this.getState() == RitualState.COMPLETING || this.getState() == RitualState.PROCESSING_RITUAL) {
            return false;
        }
        if (!this.func_70089_S()) {
            return false;
        }
        boolean integrityCheck = this.checkRitualIntegrity(checkReagents);
        if (!integrityCheck) {
            this.cancelRitual(true);
            if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
                float radius = this.__cachedCurrentRitual == null ? 2.5f : (float)this.__cachedCurrentRitual.getLowerBound();
                this.field_70170_p.func_217385_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), radius, this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
                this.setState(RitualState.DEAD);
            }
            return false;
        }
        return true;
    }

    private boolean checkRitualIntegrity(boolean checkReagents) {
        NonNullList<RitualBlockPos> locations = this.getRitualData((byte)0);
        for (int i = 0; i < locations.size(); ++i) {
            ChalkRuneTile te;
            if (!this.field_70170_p.func_195588_v(((RitualBlockPos)locations.get(i)).getBlockPos()) || this.field_70170_p.func_180495_p(((RitualBlockPos)locations.get(i)).getBlockPos()).func_177230_c() != ((Block)BlockInit.CHALK_RUNE.get()).func_176223_P().func_177230_c()) {
                return false;
            }
            if (!checkReagents || ((RitualBlockPos)locations.get(i)).getIndex() < 0 || !((RitualBlockPos)locations.get(i)).isPresent() || ((RitualBlockPos)locations.get(i)).getReagent().isOptional() || (te = (ChalkRuneTile)this.field_70170_p.func_175625_s(((RitualBlockPos)locations.get(i)).getBlockPos())).MatchesReagent(((RitualBlockPos)locations.get(i)).getReagent().getResourceLocation())) continue;
            return false;
        }
        return true;
    }

    private void findPatternEntity() {
        Optional<EntityManaweave> patternEntity = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(10.0), entity -> {
            if (!(entity instanceof EntityManaweave)) {
                return false;
            }
            EntityManaweave mw = (EntityManaweave)((Object)entity);
            ArrayList<ManaweavingPattern> p = mw.getPatterns();
            if (p.size() != 1) {
                return false;
            }
            return p.get(0).func_199560_c().toString().equals(this.getRequestedPattern().func_199560_c().toString());
        }).stream().map(e -> (EntityManaweave)((Object)e)).findFirst();
        if (patternEntity != null && patternEntity.isPresent()) {
            this.setCurrentEntityTarget(patternEntity.get());
            patternEntity.get().setMerging(true);
        }
    }

    public boolean cancelRitual() {
        return this.cancelRitual(false);
    }

    private boolean cancelRitual(boolean ignoreState) {
        if (!this.field_70170_p.field_72995_K && (ignoreState || this.getState() == RitualState.GUIDING_REAGENT_PLACEMENT)) {
            NonNullList<RitualBlockPos> locations = this.getRitualData((byte)0);
            for (RitualBlockPos pos : locations) {
                TileEntity te = this.field_70170_p.func_175625_s(pos.getBlockPos());
                if (te == null || !(te instanceof ChalkRuneTile)) continue;
                if (this.field_70170_p.func_180495_p(pos.getBlockPos()).func_177230_c() == BlockInit.CHALK_RUNE.get()) {
                    ((ChalkRuneTile)te).setReadOnly(false);
                    this.field_70170_p.func_175656_a(pos.getBlockPos(), (BlockState)this.field_70170_p.func_180495_p(pos.getBlockPos()).func_206870_a((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                this.field_70170_p.func_175656_a(pos.getBlockPos(), Blocks.field_150350_a.func_176223_P());
            }
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private void PlaySounds() {
        if (this.curState == RitualState.POWERING_UP && this.stageTicks == 0) {
            this.PlaySound(SFX.Spell.Cast.ARCANE);
            if (this.getHandlers().size() > 0) {
                RitualEffect effect = (RitualEffect)((Object)this.getHandlers().get((int)(Math.random() * (double)this.getHandlers().size())));
                this.PlayLoopingSound(effect.getLoopSound(new RitualContext(this.getCaster(), this)));
            } else {
                this.PlayLoopingSound(SFX.Loops.ENDER);
            }
        }
        if (this.curState.ordinal() >= RitualState.POWERING_UP.ordinal() && this.curState != RitualState.COMPLETING) {
            int beamAge;
            int points;
            int radiant_ticks = (int)Math.ceil(10.0f * this.getSpeed());
            int maxPos = this.age / radiant_ticks;
            if (maxPos < (points = this.getRitualData((byte)2).size()) + 1 && this.age % radiant_ticks == 0) {
                this.PlaySound(SFX.Ritual.Effects.RITUAL_POINT_APPEAR);
            }
            if ((beamAge = this.age - radiant_ticks * points) == 5) {
                this.PlaySound(SFX.Spell.Cast.ENDER);
            }
        }
    }

    private void PlaySound(SoundEvent soundID) {
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundID, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityAliveLoopingSound(soundID, this));
    }

    private void SpawnParticles() {
        boolean useDefault = false;
        RitualContext context = new RitualContext(this.getCaster(), this);
        for (RitualEffect effect : this.getHandlers()) {
            useDefault |= !effect.spawnRitualParticles(context);
        }
        RitualState curState = this.getState();
        NonNullList<RitualBlockPos> positions = this.getRitualData((byte)1);
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos cur = ((RitualBlockPos)positions.get(i)).getBlockPos();
            if (useDefault && curState.ordinal() > RitualState.POWERING_UP.ordinal()) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), (double)cur.func_177958_n() + Math.random(), (double)cur.func_177956_o(), (double)cur.func_177952_p() + Math.random(), 0.0, Math.random() * (double)0.05f + (double)0.05f, 0.0);
            }
            if (curState == RitualState.COLLECTING_PATTERNS && this.getCurrentEntityTarget() != null) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), -0.5 + this.getCurrentEntityTarget().func_226277_ct_() + Math.random(), -0.5 + this.getCurrentEntityTarget().func_226278_cu_() + Math.random(), -0.5 + this.getCurrentEntityTarget().func_226281_cx_() + Math.random(), this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
            }
            if (this.getStageTicks() != this.getShutdownAge()) continue;
            for (int j = 0; j < 10; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_RANDOM.get())), (double)cur.func_177958_n() + Math.random(), (double)cur.func_177956_o(), (double)cur.func_177952_p() + Math.random(), (double)0.1f, (double)0.1f, (double)0.1f);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_LOCATIONS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(RITUAL_STATE, (Object)((byte)RitualState.GUIDING_REAGENT_PLACEMENT.ordinal()));
        this.field_70180_af.func_187214_a(RITUAL_NAME, (Object)"");
        this.field_70180_af.func_187214_a(SHUTDOWN_AGE, (Object)-1);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CASTER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(REQUESTED_PATTERN, (Object)"");
        this.field_70180_af.func_187214_a(CURRENT_ENTITY, (Object)-1);
        this.field_70180_af.func_187214_a(VALID_LOCATIONS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(COLLECTED_REAGENTS, (Object)new CompoundNBT());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && key == COLLECTED_REAGENTS) {
            ListNBT data = ((CompoundNBT)this.field_70180_af.func_187225_a(COLLECTED_REAGENTS)).func_150295_c("data", 10);
            this.readCollectedReagents(data);
        } else if (this.field_70170_p.field_72995_K && key == RITUAL_STATE && this.getState() == RitualState.COLLECTING_REAGENTS) {
            this.worldTimeAtReagentCollectStart = this.field_70170_p.func_82737_E();
        }
        super.func_184206_a(key);
    }

    private void WriteBlockPosToNBT(String key, RitualBlockPos pos, CompoundNBT nbt) {
        CompoundNBT subNBT = new CompoundNBT();
        subNBT.func_74768_a("idx", pos.getIndex());
        subNBT.func_74768_a("d_idx", pos.getDisplayIndex());
        subNBT.func_74768_a("x", pos.getBlockPos().func_177958_n());
        subNBT.func_74768_a("y", pos.getBlockPos().func_177956_o());
        subNBT.func_74768_a("z", pos.getBlockPos().func_177952_p());
        if (pos.isPresent()) {
            ((RitualReagent)pos.getReagent()).writeToNBT(subNBT);
        }
        nbt.func_218657_a(key, (INBT)subNBT);
    }

    private RitualBlockPos ReadBlockPosFromNBT(String key, CompoundNBT nbt) {
        if (!nbt.func_74764_b(key)) {
            return null;
        }
        CompoundNBT subNBT = nbt.func_74775_l(key);
        if (!(subNBT.func_74764_b("x") && subNBT.func_74764_b("y") && subNBT.func_74764_b("z") && subNBT.func_74764_b("idx") && subNBT.func_74764_b("d_idx"))) {
            return null;
        }
        return new RitualBlockPos(subNBT.func_74762_e("idx"), subNBT.func_74762_e("d_idx"), new BlockPos(subNBT.func_74762_e("x"), subNBT.func_74762_e("y"), subNBT.func_74762_e("z")), RitualReagent.fromNBT(subNBT));
    }

    public void readCollectedReagents(ListNBT data) {
        this.collectedReagents.clear();
        for (int i = 0; i < data.size(); ++i) {
            CompoundNBT entry = data.func_150305_b(i);
            if (entry == null || !entry.func_74764_b("pos") || !entry.func_74764_b("stack")) continue;
            BlockPos pos = BlockPos.func_218283_e((long)entry.func_74763_f("pos"));
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)entry.func_74775_l("stack"));
            if (pos == null || stack == null) continue;
            this.collectedReagents.add((Object)new Pair((Object)pos, (Object)stack));
        }
        this.worldTimeAtReagentCollectStart = this.field_70170_p.func_82737_E();
        if (!this.field_70170_p.field_72995_K) {
            ListNBT list = this.writeCollectedReagents();
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("data", (INBT)list);
            this.field_70180_af.func_187227_b(COLLECTED_REAGENTS, (Object)compound);
        }
    }

    private ListNBT writeCollectedReagents() {
        ListNBT collected_reagents = new ListNBT();
        for (Pair e : this.collectedReagents) {
            CompoundNBT entry = new CompoundNBT();
            entry.func_74772_a("pos", ((BlockPos)e.getFirst()).func_218275_a());
            entry.func_218657_a("stack", (INBT)((ItemStack)e.getSecond()).func_77955_b(new CompoundNBT()));
            collected_reagents.add((Object)entry);
        }
        return collected_reagents;
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("ritual_data")) {
            int i;
            int count;
            CompoundNBT ritualData = compound.func_74775_l("ritual_data");
            if (ritualData.func_74764_b("shutdown_age")) {
                this.field_70180_af.func_187227_b(SHUTDOWN_AGE, (Object)ritualData.func_74762_e("shutdown_age"));
            }
            if (ritualData.func_74764_b("ritual_name")) {
                this.field_70180_af.func_187227_b(RITUAL_NAME, (Object)ritualData.func_74779_i("ritual_name"));
            }
            if (ritualData.func_74764_b("state")) {
                this.field_70180_af.func_187227_b(RITUAL_STATE, (Object)ritualData.func_74771_c("state"));
            }
            if (ritualData.func_74764_b("speed")) {
                this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(ritualData.func_74760_g("speed")));
            }
            if (ritualData.func_74764_b("caster")) {
                this.field_70180_af.func_187227_b(CASTER_UUID, (Object)ritualData.func_74779_i("caster"));
            }
            if (ritualData.func_74764_b("block_locations")) {
                this.field_70180_af.func_187227_b(BLOCK_LOCATIONS, (Object)((CompoundNBT)ritualData.func_74781_a("block_locations")));
            }
            if (ritualData.func_74764_b("valid_locations")) {
                this.field_70180_af.func_187227_b(VALID_LOCATIONS, (Object)((CompoundNBT)ritualData.func_74781_a("valid_locations")));
            }
            if (ritualData.func_74764_b("__dynamicReagentsCached")) {
                this.__dynamicReagentsCached = ritualData.func_74767_n("__dynamicReagentsCached");
            }
            if (ritualData.func_150297_b("collected_reagents", 9)) {
                this.readCollectedReagents(ritualData.func_150295_c("collected_reagents", 10));
            } else {
                this.remove(false);
            }
            if (ritualData.func_74764_b("forceCollectAllReagents")) {
                this.forceCollectAllReagents = ritualData.func_74767_n("forceCollectAllReagents");
            }
            if (ritualData.func_74764_b("dynamicSourceCache")) {
                this.cachedDynamicStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)ritualData.func_74781_a("dynamicSourceCache")));
            }
            if (ritualData.func_74764_b("collected_patterns")) {
                CompoundNBT collected_patterns = ritualData.func_74775_l("collected_patterns");
                count = collected_patterns.func_74762_e("count");
                for (i = 0; i < count; ++i) {
                    this.collectedPatterns.add((Object)new ResourceLocation(collected_patterns.func_74779_i("pattern_" + i)));
                }
            }
            if (ritualData.func_74764_b("required_patterns")) {
                CompoundNBT required_patterns = ritualData.func_74775_l("required_patterns");
                count = required_patterns.func_74762_e("count");
                for (i = 0; i < count; ++i) {
                    this.requiredPatterns.add((Object)new ResourceLocation(required_patterns.func_74779_i("pattern_" + i)));
                }
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        CompoundNBT ritualData = new CompoundNBT();
        ritualData.func_74768_a("shutdown_age", ((Integer)this.field_70180_af.func_187225_a(SHUTDOWN_AGE)).intValue());
        ritualData.func_74778_a("ritual_name", (String)this.field_70180_af.func_187225_a(RITUAL_NAME));
        ritualData.func_74778_a("caster", (String)this.field_70180_af.func_187225_a(CASTER_UUID));
        ritualData.func_74774_a("state", ((Byte)this.field_70180_af.func_187225_a(RITUAL_STATE)).byteValue());
        ritualData.func_74776_a("speed", ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue());
        ritualData.func_218657_a("block_locations", (INBT)this.field_70180_af.func_187225_a(BLOCK_LOCATIONS));
        ritualData.func_218657_a("valid_locations", (INBT)this.field_70180_af.func_187225_a(VALID_LOCATIONS));
        ritualData.func_74757_a("forceCollectAllReagents", this.forceCollectAllReagents);
        ritualData.func_74757_a("__dynamicReagentsCached", this.__dynamicReagentsCached);
        ritualData.func_218657_a("dynamicSourceCache", (INBT)this.cachedDynamicStack.serializeNBT());
        ritualData.func_218657_a("collected_reagents", (INBT)this.writeCollectedReagents());
        CompoundNBT collected_patterns = new CompoundNBT();
        collected_patterns.func_74768_a("count", this.collectedPatterns.size());
        for (int i = 0; i < this.collectedPatterns.size(); ++i) {
            collected_patterns.func_74778_a("pattern_" + i, ((ResourceLocation)this.collectedPatterns.get(i)).toString());
        }
        ritualData.func_218657_a("collected_patterns", (INBT)collected_patterns);
        CompoundNBT required_patterns = new CompoundNBT();
        required_patterns.func_74768_a("count", this.requiredPatterns.size());
        for (int i = 0; i < this.requiredPatterns.size(); ++i) {
            required_patterns.func_74778_a("pattern_" + i, ((ResourceLocation)this.requiredPatterns.get(i)).toString());
        }
        ritualData.func_218657_a("required_patterns", (INBT)required_patterns);
        compound.func_218657_a("ritual_data", (INBT)ritualData);
    }

    public ArrayList<BlockPos> getValidReagentLocations() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        CompoundNBT nbt = (CompoundNBT)this.field_70180_af.func_187225_a(VALID_LOCATIONS);
        if (!nbt.func_74764_b("count")) {
            return positions;
        }
        int count = nbt.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            if (nbt.func_74764_b("block_pos_" + i)) {
                CompoundNBT blockPos = nbt.func_74775_l("block_pos_" + i);
                BlockPos pos = new BlockPos(blockPos.func_74762_e("x"), blockPos.func_74762_e("y"), blockPos.func_74762_e("z"));
                positions.add(pos);
                continue;
            }
            ManaAndArtifice.LOGGER.error("Missing key block_pos_" + i + " in valid reagent locations sync data.");
        }
        return positions;
    }

    private void setValidReagentLocations(ArrayList<BlockPos> locations) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("count", locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            CompoundNBT blockPos = new CompoundNBT();
            BlockPos pos = locations.get(i);
            blockPos.func_74768_a("x", pos.func_177958_n());
            blockPos.func_74768_a("y", pos.func_177956_o());
            blockPos.func_74768_a("z", pos.func_177952_p());
            nbt.func_218657_a("block_pos_" + i, (INBT)blockPos);
        }
        this.field_70180_af.func_187227_b(VALID_LOCATIONS, (Object)nbt);
    }

    private void setCurrentEntityTarget(Entity e) {
        this.field_70180_af.func_187227_b(CURRENT_ENTITY, (Object)e.func_145782_y());
    }

    private Entity getCurrentEntityTarget() {
        if (this.__patternEntity == null || this.__patternEntity.field_70128_L) {
            this.patternConsumeTicks = 0;
            this.__patternEntity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(CURRENT_ENTITY)).intValue());
        }
        return this.__patternEntity;
    }

    public void setRequiredPatterns(Collection<ResourceLocation> patterns) {
        if (patterns == this.requiredPatterns) {
            return;
        }
        this.requiredPatterns.addAll(patterns);
    }

    public void setRitualBlockLocations(NonNullList<RitualBlockPos> locations) {
        CompoundNBT blockLocations = new CompoundNBT();
        blockLocations.func_74768_a("count", locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            this.WriteBlockPosToNBT("blockPos" + i, (RitualBlockPos)locations.get(i), blockLocations);
        }
        this.field_70180_af.func_187227_b(BLOCK_LOCATIONS, (Object)blockLocations);
    }

    public NonNullList<RitualBlockPos> getRitualData(byte mode) {
        return this.getRitualData(mode, false);
    }

    public NonNullList<RitualBlockPos> getRitualData(byte mode, boolean checkDynamicChange) {
        NonNullList positions = NonNullList.func_191196_a();
        CompoundNBT blockLocations = (CompoundNBT)this.field_70180_af.func_187225_a(BLOCK_LOCATIONS);
        if (!blockLocations.func_74764_b("count")) {
            return positions;
        }
        RitualBlockPos dynamicSupplier = null;
        boolean foundDynamics = false;
        int count = blockLocations.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            RitualBlockPos pos = this.ReadBlockPosFromNBT("blockPos" + i, blockLocations);
            if (pos == null) {
                return NonNullList.func_191196_a();
            }
            if (mode == 1 && pos.getIndex() < 0 || mode == 2 && pos.getDisplayIndex() < 0) continue;
            if (pos.getReagent() != null) {
                if (pos.getReagent().isDynamic()) {
                    foundDynamics = true;
                }
                if (pos.getReagent().isDynamicSource()) {
                    dynamicSupplier = pos;
                }
            }
            positions.add((Object)pos);
        }
        if (mode == 1 || mode == 0) {
            this.comp.setCompareIndex();
        } else if (mode == 2) {
            this.comp.setCompareDisplay();
        }
        positions.sort((Comparator)this.comp);
        if (!this.field_70170_p.field_72995_K) {
            ItemStack dynamicStack;
            TileEntity te;
            if (!this.__dynamicReagentsCached) {
                if (foundDynamics) {
                    if (dynamicSupplier == null) {
                        ManaAndArtifice.LOGGER.error("Ritual specifies dynamic reagents/patterns but no supplier is found!");
                        positions.clear();
                    } else {
                        TileEntity te2 = this.field_70170_p.func_175625_s(dynamicSupplier.getBlockPos());
                        if (te2 != null && te2 instanceof ChalkRuneTile) {
                            ItemStack dynamicStack2;
                            boolean modified = false;
                            this.cachedDynamicStack = dynamicStack2 = ((ChalkRuneTile)te2).getDisplayedItem().func_77946_l();
                            for (RitualEffect eff : this.getHandlers()) {
                                modified |= eff.getDynamicReagents(dynamicStack2, new RitualReagentReplaceContext(this.getCaster(), this, (NonNullList<RitualBlockPos>)positions));
                            }
                            if (modified) {
                                this.setRitualBlockLocations((NonNullList<RitualBlockPos>)positions);
                                this.__dynamicReagentsCached = true;
                            }
                        }
                    }
                } else {
                    this.__dynamicReagentsCached = true;
                }
            } else if (foundDynamics && checkDynamicChange && (te = this.field_70170_p.func_175625_s(dynamicSupplier.getBlockPos())) != null && te instanceof ChalkRuneTile && !ItemStack.func_77989_b((ItemStack)this.cachedDynamicStack, (ItemStack)(dynamicStack = ((ChalkRuneTile)te).getDisplayedItem().func_77946_l()))) {
                this.dynamicItemChanged = true;
            }
        }
        return positions;
    }

    private ResourceLocation getRitualName() {
        return new ResourceLocation((String)this.field_70180_af.func_187225_a(RITUAL_NAME));
    }

    public void setRitualName(ResourceLocation name) {
        this.field_70180_af.func_187227_b(RITUAL_NAME, (Object)name.toString());
        this.__cachedCurrentRitual = RitualRecipe.find(this.field_70170_p, name);
        if (this.__cachedCurrentRitual != null) {
            ArrayList<ResourceLocation> patterns = new ArrayList<ResourceLocation>();
            for (String s : this.__cachedCurrentRitual.getManaweavePatterns()) {
                patterns.add(new ResourceLocation(s));
            }
            this.setRequiredPatterns(patterns);
        }
    }

    public RitualRecipe getCurrentRitual() {
        if (this.__cachedCurrentRitual == null) {
            this.__cachedCurrentRitual = RitualRecipe.find(this.field_70170_p, this.getRitualName());
        }
        return this.__cachedCurrentRitual;
    }

    public RitualState getState() {
        return RitualState.values()[(Byte)this.field_70180_af.func_187225_a(RITUAL_STATE)];
    }

    private void setState(RitualState state) {
        this.field_70180_af.func_187227_b(RITUAL_STATE, (Object)((byte)state.ordinal()));
        if (state == RitualState.COLLECTING_REAGENTS) {
            this.worldTimeAtReagentCollectStart = this.field_70170_p.func_82737_E();
        }
    }

    private int getShutdownAge() {
        return (Integer)this.field_70180_af.func_187225_a(SHUTDOWN_AGE);
    }

    private void setShutdownAge(int shutdown_age) {
        this.field_70180_af.func_187227_b(SHUTDOWN_AGE, (Object)shutdown_age);
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        speed = MathHelper.func_76131_a((float)speed, (float)0.1f, (float)2.0f);
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed));
    }

    public void preConsumePatterns(List<ResourceLocation> patterns) {
        this.requiredPatterns.removeAll(patterns);
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.field_70180_af.func_187225_a(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    @Nullable
    private PlayerEntity getCaster() {
        if (this.getCasterUUID() == null) {
            return null;
        }
        return this.field_70170_p.func_217371_b(this.getCasterUUID());
    }

    private int getPowerupTime() {
        return (int)Math.ceil((float)(this.getRitualData((byte)2).size() * 13 + 20) * this.getSpeed());
    }

    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(3.0);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getStageTicks() {
        return this.stageTicks;
    }

    public void setStageTicks(int stageTicks) {
        this.stageTicks = stageTicks;
    }

    public void setRequestedPattern(String pattern) {
        this.field_70180_af.func_187227_b(REQUESTED_PATTERN, (Object)pattern);
    }

    public ManaweavingPattern getRequestedPattern() {
        String patternID = (String)this.field_70180_af.func_187225_a(REQUESTED_PATTERN);
        return ManaweavingPatternHelper.GetManaweavingRecipe(this.field_70170_p, new ResourceLocation(patternID));
    }

    public void setForceConsumeReagents(boolean force) {
        this.forceCollectAllReagents = force;
    }

    private NonNullList<RitualEffect> getHandlers() {
        if (this.__cachedRitualHandlers == null) {
            this.__cachedRitualHandlers = NonNullList.func_191196_a();
            for (RitualEffect eff : RitualInit.RITUAL_EFFECTS.getValues()) {
                if (!eff.handlesRitual(this.getRitualName())) continue;
                this.__cachedRitualHandlers.add((Object)eff);
            }
        }
        return this.__cachedRitualHandlers;
    }

    public NonNullList<ItemStack> getCollectedReagents() {
        NonNullList reagents = NonNullList.func_191196_a();
        reagents.addAll((Collection)this.collectedReagents.stream().map(e -> (ItemStack)e.getSecond()).collect(Collectors.toList()));
        return reagents;
    }

    public NonNullList<Pair<BlockPos, ItemStack>> getCollectedReagentsByLocation() {
        return this.collectedReagents;
    }

    public NonNullList<ResourceLocation> getCollectedPatterns() {
        NonNullList patterns = NonNullList.func_191196_a();
        patterns.addAll(this.collectedPatterns);
        return patterns;
    }

    public NonNullList<ResourceLocation> getRequiredPatterns() {
        return this.requiredPatterns;
    }

    public void func_70030_z() {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70623_bb() {
    }

    public boolean canUpdate() {
        return true;
    }

    public static enum RitualState {
        GUIDING_REAGENT_PLACEMENT,
        POWERING_UP,
        COLLECTING_REAGENTS,
        COLLECTING_PATTERNS,
        COLLAPSING,
        PROCESSING_RITUAL,
        COMPLETING,
        DEAD;

    }
}

