/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.entities.EntityInit;
import com.ma.tools.math.Vector3;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityLich
extends LivingEntity
implements IAnimatable {
    private static final DataParameter<Optional<UUID>> PLAYER = EntityDataManager.func_187226_a(EntityLich.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> REACHING = EntityDataManager.func_187226_a(EntityLich.class, (IDataSerializer)DataSerializers.field_187198_h);
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private Vector3 start;
    private Vector3 end;
    private int lerpTicks;
    private int lerpCount = 0;
    private int finishTicks = 55;
    private PlayerEntity cachedPlayer;

    public EntityLich(EntityType<? extends LivingEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
        this.field_70145_X = true;
        this.func_189654_d(true);
    }

    public EntityLich(World worldIn) {
        this((EntityType<? extends LivingEntity>)((EntityType)EntityInit.LICH.get()), worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPlayer() == null) {
                this.func_70106_y();
                return;
            }
            ++this.lerpCount;
            if (this.lerpCount <= this.lerpTicks) {
                float pct = (float)this.lerpCount / (float)this.lerpTicks;
                Vector3 pos = Vector3.lerp(this.start, this.end, pct);
                this.func_70107_b(pos.x, pos.y, pos.z);
                if (this.lerpCount < 20) {
                    this.func_200602_a(EntityAnchorArgument.Type.FEET, this.end.toVec3D());
                }
            } else {
                this.field_70180_af.func_187227_b(REACHING, (Object)true);
                if (this.lerpCount - this.lerpTicks > this.finishTicks) {
                    this.func_70106_y();
                }
            }
        }
    }

    private PlayerEntity getPlayer() {
        if (this.cachedPlayer == null && ((Optional)this.field_70180_af.func_187225_a(PLAYER)).isPresent()) {
            this.cachedPlayer = this.field_70170_p.func_217371_b((UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER)).get());
        }
        return this.cachedPlayer;
    }

    public EntityLich setPlayer(PlayerEntity player) {
        this.cachedPlayer = player;
        this.field_70180_af.func_187227_b(PLAYER, Optional.of(player.func_146103_bH().getId()));
        return this;
    }

    public EntityLich setLerpData(Vector3d start, Vector3d end, int lerpTicks) {
        this.start = new Vector3(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.end = new Vector3(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        this.lerpTicks = lerpTicks;
        return this;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!((Boolean)this.field_70180_af.func_187225_a(REACHING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lich.float", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lich.reach", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER, Optional.empty());
        this.field_70180_af.func_187214_a(REACHING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return LivingEntity.func_233639_cI_();
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_205710_ba() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }
}

