/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.affinity.Affinity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBoundArrowShot
extends AbstractArrowEntity {
    private static final DataParameter<Integer> AFFINITY = EntityDataManager.func_187226_a(EntityBoundArrowShot.class, (IDataSerializer)DataSerializers.field_187192_b);
    private ISpellDefinition spell;

    public EntityBoundArrowShot(EntityType<? extends AbstractArrowEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
    }

    public void setSpell(ISpellDefinition recipe) {
        this.spell = recipe;
        this.field_70180_af.func_187227_b(AFFINITY, (Object)this.spell.getHighestAffinity().ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AFFINITY, (Object)Affinity.ARCANE.ordinal());
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.field_70180_af.func_187225_a(AFFINITY)];
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float spread = 0.2f;
            for (int i = 0; i < 10; ++i) {
                double velMod = Math.random();
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.func_226277_ct_() - (double)spread * (Math.random() * (double)spread * 2.0), this.func_226278_cu_() - (double)spread * (Math.random() * (double)spread * 2.0), this.func_226281_cx_() - (double)spread * (Math.random() * (double)spread * 2.0), this.func_213322_ci().field_72450_a * velMod, this.func_213322_ci().field_72448_b * velMod, this.func_213322_ci().field_72449_c * velMod);
            }
        }
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.spell != null && this.spell.isValid()) {
            this.spell.writeToNBT(compound);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.spell = SpellRecipe.fromNBT(compound);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.spell != null && this.spell.isValid()) {
            Entity shooter = this.func_234616_v_();
            if (shooter != null && shooter instanceof LivingEntity) {
                SpellSource source = new SpellSource((LivingEntity)shooter, Hand.MAIN_HAND);
                SpellTarget target = new SpellTarget(result.func_216348_a());
                SpellContext context = new SpellContext((ServerWorld)this.field_70170_p, this.spell);
                SpellCaster.ApplyComponents(this.spell, source, target, context);
            }
            this.func_70106_y();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.spell != null && this.spell.isValid()) {
            Entity shooter = this.func_234616_v_();
            if (shooter != null && shooter instanceof LivingEntity) {
                SpellSource source = new SpellSource((LivingEntity)shooter, Hand.MAIN_HAND);
                SpellTarget target = new SpellTarget(result.func_216350_a(), result.func_216354_b());
                SpellContext context = new SpellContext((ServerWorld)this.field_70170_p, this.spell);
                SpellCaster.ApplyComponents(this.spell, source, target, context);
            }
            this.func_70106_y();
        }
    }
}

