/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.effects.EffectInit;
import com.ma.entities.LivingUtilityEntity;
import com.ma.tools.math.MathUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityAncientCouncil
extends LivingUtilityEntity {
    public static final byte STATE_WAITING_PLAYER = 0;
    public static final byte STATE_IMBUING = 1;
    private float radiant;
    private float radiantLift;
    private float beam;
    private float centerRadiant;

    public EntityAncientCouncil(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
        this.stateMachine.addSequenceEntry("imbue", 0).onComplete(() -> {
            this.setCurrentAnimation("imbue_stage_1");
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.ANCIENT_IMBUE_1, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        });
        this.stateMachine.addSequenceEntry("imbue", 220).onComplete(() -> {
            this.setCurrentAnimation("imbue_stage_2");
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.ANCIENT_IMBUE_2, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            } else if (this.caster != null) {
                this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 180, 1));
            }
        }).onTick(c -> {
            this.animationPct = (float)c.intValue() / 220.0f;
            this.radiant = MathUtils.clamp01((float)(c - 120) / 100.0f);
        });
        this.stateMachine.addSequenceEntry("imbue", 165).onComplete(() -> {
            this.setCurrentAnimation("imbue_stage_3");
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.ANCIENT_IMBUE_3, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            } else if (this.caster != null) {
                this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 280, 2));
            }
        }).onTick(c -> {
            this.radiantLift = this.animationPct = (float)c.intValue() / 165.0f;
        });
        this.stateMachine.addSequenceEntry("imbue", 260).onComplete(() -> {
            this.setCurrentAnimation("");
            if (this.caster != null && this.caster.func_70032_d((Entity)this) < 10.0f) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 75; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), this.caster.func_226277_ct_(), this.caster.func_226278_cu_() + 1.0, this.caster.func_226281_cx_(), -0.25 + Math.random() * 0.5, (double)0.15f, -0.25 + Math.random() * 0.5);
                    }
                } else {
                    IPlayerProgression progression = (IPlayerProgression)this.caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    if (progression != null && progression.getTier() < 5) {
                        if (progression.getAlliedFaction() == Faction.NONE) {
                            progression.setAlliedFaction(Faction.ANCIENT_WIZARDS, this.caster);
                            this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("event.mana-and-artifice.faction_ally_ancients"), Util.field_240973_b_);
                        }
                        if (progression.getAlliedFaction() == Faction.ANCIENT_WIZARDS) {
                            progression.setTier(progression.getTier() + 1, this.caster);
                            this.caster.func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:progresscondition.advanced", new Object[]{progression.getTier()}), Util.field_240973_b_);
                        }
                    }
                }
                this.remove(false);
            }
            this.centerRadiant = 0.0f;
            this.beam = 0.0f;
            this.radiant = 0.0f;
        }).onTick(c -> {
            this.animationPct = (float)c.intValue() / 260.0f;
            this.centerRadiant = MathUtils.clamp01(((float)c.intValue() - 30.0f) / 180.0f);
            this.beam = MathUtils.clamp01((float)c.intValue() / 40.0f);
        });
    }

    @Override
    public void func_70071_h_() {
        byte state;
        super.func_70071_h_();
        if (this.field_70173_aa < 100) {
            return;
        }
        if (this.caster == null) {
            this.remove(false);
        }
        if ((state = this.getState()) == 0) {
            List centerCollisions = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null);
            if (centerCollisions.contains(this.caster)) {
                this.caster.func_226286_f_(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                if (!this.field_70170_p.field_72995_K) {
                    this.caster.func_195064_c(new EffectInstance((Effect)EffectInit.LIFT.get(), 240));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.setState((byte)1);
                }
                this.stateMachine.runSequence("imbue");
            }
        } else {
            this.stateMachine.tick();
        }
        if (!this.field_70170_p.field_72995_K && (state == 0 && this.field_70173_aa > 700 || this.caster == null || this.caster.func_70032_d((Entity)this) > 10.0f)) {
            this.remove(false);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == STATE && this.getState() == 1) {
            this.stateMachine.runSequence("imbue");
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setState((byte)0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SFX.Event.Ritual.ANCIENT_SUMMON, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K) {
            int numWizards = 6;
            float angleRadians = 0.0f;
            for (int a = 0; a < numWizards; ++a) {
                for (int i = 0; i < 125; ++i) {
                    double radius = 2.75 + Math.random() * 0.5;
                    double x = this.func_226277_ct_() - 0.5 + Math.random() + radius * Math.cos(angleRadians);
                    double z = this.func_226281_cx_() - 0.5 + Math.random() + radius * Math.sin(angleRadians);
                    this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), x, this.func_226278_cu_() + Math.random() * 0.5, z, 0.0, 0.02 + Math.random() * (double)0.2f, 0.0);
                }
                angleRadians = (float)((double)angleRadians + (double)(360.0f / (float)numWizards / 180.0f) * Math.PI);
            }
        }
        this.disableFlightFor(this.caster);
    }

    public float getRadiantPct() {
        return this.radiant;
    }

    public float getBeamPct() {
        return this.beam;
    }

    public float getCenterPct() {
        return this.centerRadiant;
    }

    public float getRadiantLift() {
        return this.radiantLift;
    }
}

