/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers.ritual;

import com.ma.entities.models.AncientWizardModel;
import com.ma.entities.rituals.EntityAncientCouncil;
import com.ma.tools.render.MARenderTypes;
import com.ma.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class EntityAncientCouncilRenderer
extends EntityRenderer<EntityAncientCouncil> {
    private static final ResourceLocation ANCIENT_WIZARD_TEXTURE = new ResourceLocation("mana-and-artifice", "textures/entity/ancient_wizard.png");
    protected final AncientWizardModel modelWizard = new AncientWizardModel();

    public EntityAncientCouncilRenderer(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public ResourceLocation getTextureLocation(EntityAncientCouncil entity) {
        return ANCIENT_WIZARD_TEXTURE;
    }

    public void render(EntityAncientCouncil entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        int age = entityIn.field_70173_aa;
        matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        float angleDegrees = 0.0f;
        int numWizards = 6;
        for (int i = 0; i < numWizards; ++i) {
            matrixStackIn.func_227860_a_();
            float riseAmount = Math.min(((float)age + partialTicks) / 70.0f * 2.5f, 2.5f);
            matrixStackIn.func_227861_a_(0.0, (double)(-riseAmount), 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angleDegrees));
            matrixStackIn.func_227861_a_(-3.0, 0.0, 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            this.modelWizard.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.modelWizard.func_228282_a_(this.getTextureLocation(entityIn)));
            this.modelWizard.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
            if (entityIn.getRadiantPct() > 0.0f) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, (double)(-riseAmount), 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angleDegrees));
                matrixStackIn.func_227861_a_(-2.25, (double)(0.5f - 1.25f * entityIn.getRadiantLift()), 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                WorldRenderUtils.renderRadiant((Entity)entityIn, matrixStackIn, bufferIn, new int[]{203, 8, 112}, new int[]{151, 25, 151}, (int)Math.floor(entityIn.getRadiantPct() * 255.0f), 0.05f);
                matrixStackIn.func_227865_b_();
            }
            if (entityIn.getBeamPct() > 0.0f) {
                matrixStackIn.func_227860_a_();
                Vector3d start = entityIn.func_213303_ch().func_178787_e(new Vector3d(-2.25, -3.2, 0.0));
                Vector3d end = entityIn.func_213303_ch().func_72441_c(0.0, -5.0, 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-angleDegrees));
                matrixStackIn.func_227861_a_(-2.25, (double)-3.2f, 0.0);
                WorldRenderUtils.renderBeam(entityIn.field_70170_p, partialTicks, matrixStackIn, bufferIn, packedLightIn, start, end, entityIn.getBeamPct(), new int[]{255, 255, 255}, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                matrixStackIn.func_227865_b_();
            }
            angleDegrees += 360.0f / (float)numWizards;
        }
        if (entityIn.getCenterPct() > 0.0f) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, -5.0, 0.0);
            WorldRenderUtils.renderRadiant((Entity)entityIn, matrixStackIn, bufferIn, new int[]{151, 25, 151}, new int[]{77, 133, 207}, (int)Math.floor(entityIn.getCenterPct() * 255.0f), 0.15f);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected boolean shouldShowName(EntityAncientCouncil entity) {
        return false;
    }
}

