/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai.base;

import com.ma.api.blocks.IRequirePlayerReference;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRuneMarking;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public abstract class ConstructCommandTileEntityInteract<T extends TileEntity>
extends ConstructCommand {
    protected BlockPos blockPos;
    protected Direction side;
    private Class<T> teClass;
    private T _cached_te_ref;
    private Vector3d lastConstructPos;
    private float stuckPosThreshold = 0.25f;
    private int stuckCount = 0;
    private int stuckCountThreshold = 20;
    private Direction[] offsetDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    public ConstructCommandTileEntityInteract(EntityAnimatedConstruct construct, Class<T> tileEntityClass) {
        super(construct);
        this.teClass = tileEntityClass;
    }

    public void setTileEntity(BlockPos pos, Direction side) {
        this.blockPos = pos;
        this.side = side;
        this._cached_te_ref = null;
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.blockPos != null && this.construct.field_70170_p.func_195588_v(this.blockPos) && this.teClass.isInstance(this.construct.field_70170_p.func_175625_s(this.blockPos));
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.blockPos != null && this.construct.field_70170_p.func_195588_v(this.blockPos) && this.teClass.isInstance(this.construct.field_70170_p.func_175625_s(this.blockPos));
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this._cached_te_ref = null;
        T te = this.getTileEntity();
        if (te != null && this.teClass.isInstance(te)) {
            this._cached_te_ref = te;
        }
    }

    @Nullable
    protected T getTileEntity() {
        TileEntity te;
        if (this.blockPos == null) {
            return null;
        }
        if (this._cached_te_ref == null && this.construct.field_70170_p.func_195588_v(this.blockPos) && this.teClass.isInstance(te = this.construct.field_70170_p.func_175625_s(this.blockPos))) {
            this._cached_te_ref = te;
        }
        return this._cached_te_ref;
    }

    protected void preInteract() {
        if (this.getTileEntity() instanceof IRequirePlayerReference) {
            ((IRequirePlayerReference)this.getTileEntity()).setPlayerReference(this.getOrCreatePlayer());
        }
    }

    @Override
    protected boolean doMove() {
        if (this.getTileEntity() == null) {
            return false;
        }
        BlockPos tePos = this.getTileEntity().func_174877_v();
        Vector3d invPos = new Vector3d((double)tePos.func_177958_n() + 0.5, (double)tePos.func_177956_o() + 0.5, (double)tePos.func_177952_p() + 0.5);
        double dist = this.construct.func_195048_a(invPos);
        if (dist > 2.5) {
            if (this.moveCooldown == 0) {
                Vector3d constructPos = this.construct.func_213303_ch();
                if (this.lastConstructPos != null) {
                    if (constructPos.func_72436_e(this.lastConstructPos) < (double)(this.stuckPosThreshold * this.stuckPosThreshold)) {
                        ++this.stuckCount;
                        if (this.stuckCount >= 2) {
                            Direction dir = this.offsetDirections[(int)(Math.random() * (double)this.offsetDirections.length)];
                            this.construct.func_70661_as().func_75499_g();
                            if (this.construct.func_70661_as().func_75492_a(this.construct.func_226277_ct_() + (double)(dir.func_82601_c() * 3), this.construct.func_226278_cu_() + (double)(dir.func_96559_d() * 3), this.construct.func_226281_cx_() + (double)(dir.func_82599_e() * 3), this.construct.func_233637_b_(Attributes.field_233821_d_))) {
                                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_success", invPos.field_72450_a, invPos.field_72448_b, invPos.field_72449_c), false);
                            } else {
                                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_fail", invPos.field_72450_a, invPos.field_72448_b, invPos.field_72449_c), false);
                            }
                            this.moveCooldown = 20;
                            this.stuckCount = 0;
                            return false;
                        }
                    } else {
                        this.stuckCount = 0;
                    }
                }
                this.lastConstructPos = constructPos;
                this.setPathToXYZ(invPos, 1.0f);
                this.moveCooldown = 20;
            }
        } else {
            this.construct.func_70661_as().func_75499_g();
            this.faceBlockPos(tePos);
            return true;
        }
        return false;
    }

    protected void faceBlockPos(BlockPos pos) {
        double d0 = (double)pos.func_177958_n() + 0.5 - this.construct.func_226277_ct_();
        double d2 = (double)pos.func_177952_p() + 0.5 - this.construct.func_226281_cx_();
        double d1 = (double)pos.func_177956_o() + 0.5;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
        this.construct.field_70125_A = this.updateRotation(this.construct.field_70125_A, f1, 30.0f);
        this.construct.field_70177_z = this.updateRotation(this.construct.field_70177_z, f, 30.0f);
    }

    private float updateRotation(float start, float end, float step) {
        float f = MathHelper.func_76142_g((float)(end - start));
        if (f > step) {
            f = step;
        }
        if (f < -step) {
            f = -step;
        }
        return start + f;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructCommandTileEntityInteract && this.teClass == ((ConstructCommandTileEntityInteract)other).teClass) {
            this.side = ((ConstructCommandTileEntityInteract)other).side;
            this.blockPos = ((ConstructCommandTileEntityInteract)other).blockPos;
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.func_74768_a("direction", this.side.func_176745_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("blockPos")) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("blockPos"));
        }
        if (nbt.func_74764_b("direction")) {
            this.side = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
        }
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.blockPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
            this.side = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(marker);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

