/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai.base;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.constructs.parts._base.ConstructMaterial;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class ConstructCommand
extends Goal {
    protected static final int MOVE_COOLDOWN = 20;
    protected static final int SWING_BUFFER_TIME = 5;
    protected EntityAnimatedConstruct construct;
    protected PlayerEntity owner;
    protected boolean isFinished = false;
    protected boolean isSuccess = false;
    protected int pathCooldown = 0;
    protected int moveCooldown;
    protected int teleportCooldown = 0;
    protected BlockPos moveBlockTarget = null;
    protected Entity moveEntityTarget = null;
    protected int attackCooldown = 0;

    public ConstructCommand(EntityAnimatedConstruct construct) {
        this.construct = construct;
    }

    public void setConstruct(EntityAnimatedConstruct construct) {
        this.construct = construct;
    }

    protected boolean doMove() {
        return this.doMove(2.5f);
    }

    protected boolean doMove(float closeEnough) {
        if (this.moveEntityTarget != null && !this.moveEntityTarget.func_70089_S()) {
            this.moveEntityTarget = null;
        }
        if (this.moveBlockTarget == null && this.moveEntityTarget == null) {
            return false;
        }
        Vector3d invPos = this.moveEntityTarget != null ? this.moveEntityTarget.func_213303_ch() : new Vector3d((double)this.moveBlockTarget.func_177958_n() + 0.5, (double)this.moveBlockTarget.func_177956_o(), (double)this.moveBlockTarget.func_177952_p() + 0.5);
        double dist = this.construct.func_195048_a(invPos);
        boolean movecomplete = false;
        if (dist > (double)closeEnough) {
            if (this.moveCooldown == 0) {
                movecomplete = this.moveEntityTarget != null ? this.setPathToEntity(this.moveEntityTarget, closeEnough) : this.setPathToXYZ(invPos, closeEnough);
                this.moveCooldown = 20;
            }
        } else {
            movecomplete = true;
        }
        if (movecomplete) {
            this.construct.func_70661_as().func_75499_g();
            return true;
        }
        return false;
    }

    protected boolean setPathToEntity(Entity entity, float closeEnough) {
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.TELEPORT) && this.teleportCooldown <= 0) {
            return this.setPathToXYZ(entity.func_213303_ch(), closeEnough);
        }
        double dist = entity.func_213303_ch().func_72436_e(this.construct.func_213303_ch());
        if (dist < (double)closeEnough) {
            return true;
        }
        this.construct.func_70659_e((float)this.construct.func_233637_b_(Attributes.field_233821_d_));
        if (this.construct.func_70661_as().func_75497_a(entity, (double)this.construct.func_70689_ay())) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_entity_success", this.translate(entity)), false);
        } else {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_entity_fail", this.translate(entity)), false);
        }
        return false;
    }

    protected boolean setPathToXYZ(Vector3d pos, float closeEnough) {
        double dist = pos.func_72436_e(this.construct.func_213303_ch());
        if (dist < (double)closeEnough) {
            return true;
        }
        if (this.construct.getConstructData().isCapabilityEnabled(ConstructCapability.TELEPORT) && this.teleportCooldown <= 0) {
            Vector3d targetPos = pos.func_178787_e(this.construct.func_213303_ch().func_178788_d(pos).func_72432_b().func_186678_a((double)(closeEnough * 0.9f)));
            if (dist >= 48.0 || dist <= 32.0 && (dist > 6.0 || this.construct.field_70170_p.func_217299_a(new RayTraceContext(this.construct.func_213303_ch(), targetPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, null)).func_216346_c() != RayTraceResult.Type.MISS)) {
                this.teleportCooldown = this.getInteractTime(ConstructCapability.TELEPORT, 5, 30);
                if (this.construct.func_213373_a(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, false)) {
                    this.construct.field_70170_p.func_184148_a((PlayerEntity)null, this.construct.field_70169_q, this.construct.field_70167_r, this.construct.field_70166_s, SoundEvents.field_187534_aX, this.construct.func_184176_by(), 1.0f, 1.0f);
                    this.construct.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    this.construct.func_200602_a(EntityAnchorArgument.Type.FEET, pos);
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_block_success", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), false);
                    return true;
                }
            }
        }
        this.construct.func_70659_e((float)this.construct.func_233637_b_(Attributes.field_233821_d_));
        if (this.construct.func_70661_as().func_75492_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)this.construct.func_70689_ay())) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_block_success", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), false);
        } else {
            double[] dists;
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.move_block_fail", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), false);
            BlockPos blockPos = new BlockPos(pos);
            for (double bpDist : dists = new double[]{blockPos.func_218138_a((IPosition)pos, false), blockPos.func_177982_a(1, 0, 0).func_218138_a((IPosition)pos, false), blockPos.func_177982_a(0, 0, 1).func_218138_a((IPosition)pos, false), blockPos.func_177982_a(1, 0, 1).func_218138_a((IPosition)pos, false)}) {
                if (!(bpDist <= (double)closeEnough)) continue;
                return true;
            }
            this.construct.func_200602_a(EntityAnchorArgument.Type.FEET, pos);
            this.construct.func_213315_a(MoverType.SELF, pos.func_178788_d(this.construct.func_213303_ch()).func_72432_b().func_186678_a((double)((float)this.construct.func_233637_b_(Attributes.field_233821_d_))));
        }
        return false;
    }

    protected boolean doAttack() {
        this.moveEntityTarget = this.construct.func_70638_az();
        int ranged_result = this.doRangedAttack();
        if (ranged_result != -1) {
            return ranged_result != 0;
        }
        return this.doMeleeAttack();
    }

    private boolean doMeleeAttack() {
        if (!this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.MELEE_ATTACK)) {
            return true;
        }
        double targetDist = this.construct.func_70068_e(this.moveEntityTarget);
        if (targetDist < 4.0 && this.attackCooldown <= 0) {
            this.construct.getHandWithCapability(ConstructCapability.MELEE_ATTACK).ifPresent(h -> {
                this.construct.func_184609_a((Hand)h);
                DelayedEventQueue.pushEvent(this.construct.field_70170_p, new TimedDelayedEvent<Entity>("attack", 8, this.moveEntityTarget, this::meleeAttackCallback));
            });
            return true;
        }
        this.doMove();
        return false;
    }

    private void meleeAttackCallback(String identifier, Entity target) {
        if (target == null) {
            return;
        }
        this.attackCooldown = (int)this.construct.func_110148_a(Attributes.field_233825_h_).func_111126_e();
        this.construct.func_70652_k(target);
    }

    private int doRangedAttack() {
        if (!(this.construct.isRangedAttacking() || this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.RANGED_ATTACK) && this.construct.hasManaForRangedAttack() && !(this.construct.func_70032_d((Entity)this.construct.func_70638_az()) < 3.0f))) {
            return -1;
        }
        if (this.doMove(144.0f) && this.construct.performRangedAttack(this.construct.func_70638_az())) {
            return 1;
        }
        return 0;
    }

    public void func_75246_d() {
        if (this.moveCooldown > 0) {
            --this.moveCooldown;
        }
        if (this.pathCooldown > 0) {
            --this.pathCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.owner != null && !this.owner.func_70089_S()) {
            this.owner = null;
        }
    }

    public boolean func_75250_a() {
        return this.construct != null;
    }

    public boolean func_75253_b() {
        return !this.isFinished();
    }

    public void func_75249_e() {
        if (this.construct != null) {
            this.owner = this.construct.getOwner();
        }
        this.isFinished = false;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.isFinished = false;
        this.isSuccess = false;
    }

    protected String translate(String key, Object ... args) {
        return new TranslationTextComponent(key, args).getString();
    }

    protected String translate(TileEntity te) {
        return this.translate(te.func_195044_w());
    }

    protected String translate(ItemStack stack) {
        return this.translate(stack.func_77977_a(), new Object[0]);
    }

    protected String translate(BlockState state) {
        return this.translate(state.func_177230_c().func_149739_a(), new Object[0]);
    }

    protected String translate(Entity e) {
        return this.translate(e.func_200600_R().func_210760_d(), new Object[0]);
    }

    protected PlayerEntity getOrCreatePlayer() {
        if (this.owner == null) {
            this.owner = this.construct.getOwner();
        }
        return this.owner != null && this.owner.func_70068_e((Entity)this.construct) < 4096.0 ? this.owner : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.construct.field_70170_p));
    }

    protected void insertOrDropItem(ItemStack stack) {
        int i;
        int limit = this.construct.getCarrySize();
        Hand[] hands = this.construct.getCarryingHands();
        for (i = 0; i < hands.length; ++i) {
            ItemStack carried = this.construct.func_184586_b(hands[i]);
            if (!carried.func_185136_b(stack)) continue;
            if (carried.func_190916_E() + stack.func_190916_E() <= limit) {
                carried.func_190920_e(carried.func_190916_E() + stack.func_190916_E());
                return;
            }
            if (carried.func_190916_E() >= limit) continue;
            int remaining = limit - carried.func_190916_E();
            carried.func_190920_e(limit);
            stack.func_190920_e(remaining);
        }
        hands = this.construct.getEmptyHands();
        for (i = 0; i < hands.length; ++i) {
            if (stack.func_190916_E() <= limit) {
                this.construct.func_184611_a(hands[i], stack);
                return;
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(limit);
            stack.func_190920_e(stack.func_190916_E() - limit);
            this.construct.func_184611_a(hands[i], copy);
        }
        if (!stack.func_190926_b()) {
            ItemEntity drop = new ItemEntity(this.construct.field_70170_p, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), stack);
            drop.func_213293_j(0.0, 0.25, 0.0);
            drop.func_174869_p();
            this.construct.field_70170_p.func_217376_c((Entity)drop);
        }
    }

    protected List<ItemStack> getHeldItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!this.construct.func_184614_ca().func_190926_b()) {
            stacks.add(this.construct.func_184614_ca());
        }
        if (!this.construct.func_184592_cb().func_190926_b()) {
            stacks.add(this.construct.func_184592_cb());
        }
        return stacks;
    }

    public abstract ConstructActions getType();

    public abstract void copyFrom(ConstructCommand var1);

    public abstract void readNBT(CompoundNBT var1);

    protected abstract CompoundNBT writeInternal(CompoundNBT var1);

    public abstract void getDataFromInventory(Inventory var1);

    public abstract boolean isFullyConfigured();

    protected int getInteractTime(ConstructCapability capability, int multiplier, int fallback) {
        if (this.construct == null) {
            return 30;
        }
        ConstructMaterial material = this.construct.getConstructData().getHighestMaterialForCapability(capability);
        if (material == null) {
            return fallback;
        }
        int inverseOrdinal = ConstructMaterial.values().length - material.ordinal();
        return Math.max(inverseOrdinal * multiplier, 5);
    }

    protected int getInteractTime(ConstructCapability capability) {
        return this.getInteractTime(capability, 5, 30);
    }

    public ConstructCapability[] requiredCapabilities() {
        return new ConstructCapability[0];
    }

    public final CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("type", this.getType().ordinal());
        this.writeInternal(nbt);
        return nbt;
    }

    public void onTaskSet() {
    }

    public static final ConstructActions getTypeFromNBT(CompoundNBT nbt) {
        int ordinal = nbt.func_74762_e("type");
        if (ordinal >= 0 && ordinal < ConstructActions.values().length) {
            return ConstructActions.values()[ordinal];
        }
        return ConstructActions.STAY;
    }

    public Inventory createConfigurationInventory() {
        return new Inventory(0);
    }
}

